/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.AKSVolumeTypes;
import com.azure.resourcemanager.dataprotection.models.BackupDatasourceParameters;
import com.azure.resourcemanager.dataprotection.models.NamespacedNameResource;
import java.io.IOException;
import java.util.List;

public final class KubernetesClusterBackupDatasourceParameters
extends BackupDatasourceParameters {
    private String objectType = "KubernetesClusterBackupDatasourceParameters";
    private boolean snapshotVolumes;
    private List<AKSVolumeTypes> includedVolumeTypes;
    private boolean includeClusterScopeResources;
    private List<String> includedNamespaces;
    private List<String> excludedNamespaces;
    private List<String> includedResourceTypes;
    private List<String> excludedResourceTypes;
    private List<String> labelSelectors;
    private List<NamespacedNameResource> backupHookReferences;

    @Override
    public String objectType() {
        return this.objectType;
    }

    public boolean snapshotVolumes() {
        return this.snapshotVolumes;
    }

    public KubernetesClusterBackupDatasourceParameters withSnapshotVolumes(boolean snapshotVolumes) {
        this.snapshotVolumes = snapshotVolumes;
        return this;
    }

    public List<AKSVolumeTypes> includedVolumeTypes() {
        return this.includedVolumeTypes;
    }

    public KubernetesClusterBackupDatasourceParameters withIncludedVolumeTypes(List<AKSVolumeTypes> includedVolumeTypes) {
        this.includedVolumeTypes = includedVolumeTypes;
        return this;
    }

    public boolean includeClusterScopeResources() {
        return this.includeClusterScopeResources;
    }

    public KubernetesClusterBackupDatasourceParameters withIncludeClusterScopeResources(boolean includeClusterScopeResources) {
        this.includeClusterScopeResources = includeClusterScopeResources;
        return this;
    }

    public List<String> includedNamespaces() {
        return this.includedNamespaces;
    }

    public KubernetesClusterBackupDatasourceParameters withIncludedNamespaces(List<String> includedNamespaces) {
        this.includedNamespaces = includedNamespaces;
        return this;
    }

    public List<String> excludedNamespaces() {
        return this.excludedNamespaces;
    }

    public KubernetesClusterBackupDatasourceParameters withExcludedNamespaces(List<String> excludedNamespaces) {
        this.excludedNamespaces = excludedNamespaces;
        return this;
    }

    public List<String> includedResourceTypes() {
        return this.includedResourceTypes;
    }

    public KubernetesClusterBackupDatasourceParameters withIncludedResourceTypes(List<String> includedResourceTypes) {
        this.includedResourceTypes = includedResourceTypes;
        return this;
    }

    public List<String> excludedResourceTypes() {
        return this.excludedResourceTypes;
    }

    public KubernetesClusterBackupDatasourceParameters withExcludedResourceTypes(List<String> excludedResourceTypes) {
        this.excludedResourceTypes = excludedResourceTypes;
        return this;
    }

    public List<String> labelSelectors() {
        return this.labelSelectors;
    }

    public KubernetesClusterBackupDatasourceParameters withLabelSelectors(List<String> labelSelectors) {
        this.labelSelectors = labelSelectors;
        return this;
    }

    public List<NamespacedNameResource> backupHookReferences() {
        return this.backupHookReferences;
    }

    public KubernetesClusterBackupDatasourceParameters withBackupHookReferences(List<NamespacedNameResource> backupHookReferences) {
        this.backupHookReferences = backupHookReferences;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("snapshotVolumes", this.snapshotVolumes);
        jsonWriter.writeBooleanField("includeClusterScopeResources", this.includeClusterScopeResources);
        jsonWriter.writeStringField("objectType", this.objectType);
        jsonWriter.writeArrayField("includedVolumeTypes", this.includedVolumeTypes, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("includedNamespaces", this.includedNamespaces, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("excludedNamespaces", this.excludedNamespaces, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("includedResourceTypes", this.includedResourceTypes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("excludedResourceTypes", this.excludedResourceTypes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("labelSelectors", this.labelSelectors, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("backupHookReferences", this.backupHookReferences, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static KubernetesClusterBackupDatasourceParameters fromJson(JsonReader jsonReader) throws IOException {
        return (KubernetesClusterBackupDatasourceParameters)jsonReader.readObject(reader -> {
            KubernetesClusterBackupDatasourceParameters deserializedKubernetesClusterBackupDatasourceParameters = new KubernetesClusterBackupDatasourceParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("snapshotVolumes".equals(fieldName)) {
                    deserializedKubernetesClusterBackupDatasourceParameters.snapshotVolumes = reader.getBoolean();
                    continue;
                }
                if ("includeClusterScopeResources".equals(fieldName)) {
                    deserializedKubernetesClusterBackupDatasourceParameters.includeClusterScopeResources = reader.getBoolean();
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedKubernetesClusterBackupDatasourceParameters.objectType = reader.getString();
                    continue;
                }
                if ("includedVolumeTypes".equals(fieldName)) {
                    List includedVolumeTypes;
                    deserializedKubernetesClusterBackupDatasourceParameters.includedVolumeTypes = includedVolumeTypes = reader.readArray(reader1 -> AKSVolumeTypes.fromString(reader1.getString()));
                    continue;
                }
                if ("includedNamespaces".equals(fieldName)) {
                    List includedNamespaces;
                    deserializedKubernetesClusterBackupDatasourceParameters.includedNamespaces = includedNamespaces = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("excludedNamespaces".equals(fieldName)) {
                    List excludedNamespaces;
                    deserializedKubernetesClusterBackupDatasourceParameters.excludedNamespaces = excludedNamespaces = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("includedResourceTypes".equals(fieldName)) {
                    List includedResourceTypes;
                    deserializedKubernetesClusterBackupDatasourceParameters.includedResourceTypes = includedResourceTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("excludedResourceTypes".equals(fieldName)) {
                    List excludedResourceTypes;
                    deserializedKubernetesClusterBackupDatasourceParameters.excludedResourceTypes = excludedResourceTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("labelSelectors".equals(fieldName)) {
                    List labelSelectors;
                    deserializedKubernetesClusterBackupDatasourceParameters.labelSelectors = labelSelectors = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("backupHookReferences".equals(fieldName)) {
                    List backupHookReferences;
                    deserializedKubernetesClusterBackupDatasourceParameters.backupHookReferences = backupHookReferences = reader.readArray(reader1 -> NamespacedNameResource.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKubernetesClusterBackupDatasourceParameters;
        });
    }
}

