/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.AzureBackupRestoreRequest;
import com.azure.resourcemanager.dataprotection.models.IdentityDetails;
import com.azure.resourcemanager.dataprotection.models.RestoreTargetInfoBase;
import com.azure.resourcemanager.dataprotection.models.SourceDataStoreType;
import java.io.IOException;
import java.util.List;

public final class AzureBackupRecoveryTimeBasedRestoreRequest
extends AzureBackupRestoreRequest {
    private String objectType = "AzureBackupRecoveryTimeBasedRestoreRequest";
    private String recoveryPointTime;

    @Override
    public String objectType() {
        return this.objectType;
    }

    public String recoveryPointTime() {
        return this.recoveryPointTime;
    }

    public AzureBackupRecoveryTimeBasedRestoreRequest withRecoveryPointTime(String recoveryPointTime) {
        this.recoveryPointTime = recoveryPointTime;
        return this;
    }

    @Override
    public AzureBackupRecoveryTimeBasedRestoreRequest withRestoreTargetInfo(RestoreTargetInfoBase restoreTargetInfo) {
        super.withRestoreTargetInfo(restoreTargetInfo);
        return this;
    }

    @Override
    public AzureBackupRecoveryTimeBasedRestoreRequest withSourceDataStoreType(SourceDataStoreType sourceDataStoreType) {
        super.withSourceDataStoreType(sourceDataStoreType);
        return this;
    }

    @Override
    public AzureBackupRecoveryTimeBasedRestoreRequest withSourceResourceId(String sourceResourceId) {
        super.withSourceResourceId(sourceResourceId);
        return this;
    }

    @Override
    public AzureBackupRecoveryTimeBasedRestoreRequest withResourceGuardOperationRequests(List<String> resourceGuardOperationRequests) {
        super.withResourceGuardOperationRequests(resourceGuardOperationRequests);
        return this;
    }

    @Override
    public AzureBackupRecoveryTimeBasedRestoreRequest withIdentityDetails(IdentityDetails identityDetails) {
        super.withIdentityDetails(identityDetails);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("restoreTargetInfo", (JsonSerializable)this.restoreTargetInfo());
        jsonWriter.writeStringField("sourceDataStoreType", this.sourceDataStoreType() == null ? null : this.sourceDataStoreType().toString());
        jsonWriter.writeStringField("sourceResourceId", this.sourceResourceId());
        jsonWriter.writeArrayField("resourceGuardOperationRequests", this.resourceGuardOperationRequests(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identityDetails", (JsonSerializable)this.identityDetails());
        jsonWriter.writeStringField("recoveryPointTime", this.recoveryPointTime);
        jsonWriter.writeStringField("objectType", this.objectType);
        return jsonWriter.writeEndObject();
    }

    public static AzureBackupRecoveryTimeBasedRestoreRequest fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBackupRecoveryTimeBasedRestoreRequest)jsonReader.readObject(reader -> {
            AzureBackupRecoveryTimeBasedRestoreRequest deserializedAzureBackupRecoveryTimeBasedRestoreRequest = new AzureBackupRecoveryTimeBasedRestoreRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("restoreTargetInfo".equals(fieldName)) {
                    deserializedAzureBackupRecoveryTimeBasedRestoreRequest.withRestoreTargetInfo(RestoreTargetInfoBase.fromJson(reader));
                    continue;
                }
                if ("sourceDataStoreType".equals(fieldName)) {
                    deserializedAzureBackupRecoveryTimeBasedRestoreRequest.withSourceDataStoreType(SourceDataStoreType.fromString(reader.getString()));
                    continue;
                }
                if ("sourceResourceId".equals(fieldName)) {
                    deserializedAzureBackupRecoveryTimeBasedRestoreRequest.withSourceResourceId(reader.getString());
                    continue;
                }
                if ("resourceGuardOperationRequests".equals(fieldName)) {
                    List resourceGuardOperationRequests = reader.readArray(reader1 -> reader1.getString());
                    deserializedAzureBackupRecoveryTimeBasedRestoreRequest.withResourceGuardOperationRequests(resourceGuardOperationRequests);
                    continue;
                }
                if ("identityDetails".equals(fieldName)) {
                    deserializedAzureBackupRecoveryTimeBasedRestoreRequest.withIdentityDetails(IdentityDetails.fromJson(reader));
                    continue;
                }
                if ("recoveryPointTime".equals(fieldName)) {
                    deserializedAzureBackupRecoveryTimeBasedRestoreRequest.recoveryPointTime = reader.getString();
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedAzureBackupRecoveryTimeBasedRestoreRequest.objectType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureBackupRecoveryTimeBasedRestoreRequest;
        });
    }
}

