/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dataprotection.DataProtectionManager;
import com.azure.resourcemanager.dataprotection.fluent.OperationStatusResourceGroupContextsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.OperationResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.OperationResourceImpl;
import com.azure.resourcemanager.dataprotection.models.OperationResource;
import com.azure.resourcemanager.dataprotection.models.OperationStatusResourceGroupContexts;

public final class OperationStatusResourceGroupContextsImpl
implements OperationStatusResourceGroupContexts {
    private static final ClientLogger LOGGER = new ClientLogger(OperationStatusResourceGroupContextsImpl.class);
    private final OperationStatusResourceGroupContextsClient innerClient;
    private final DataProtectionManager serviceManager;

    public OperationStatusResourceGroupContextsImpl(OperationStatusResourceGroupContextsClient innerClient, DataProtectionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<OperationResource> getByResourceGroupWithResponse(String resourceGroupName, String operationId, Context context) {
        Response<OperationResourceInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, operationId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new OperationResourceImpl((OperationResourceInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public OperationResource getByResourceGroup(String resourceGroupName, String operationId) {
        OperationResourceInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, operationId);
        if (inner != null) {
            return new OperationResourceImpl(inner, this.manager());
        }
        return null;
    }

    private OperationStatusResourceGroupContextsClient serviceClient() {
        return this.innerClient;
    }

    private DataProtectionManager manager() {
        return this.serviceManager;
    }
}

