/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dataprotection.fluent.JobsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.AzureBackupJobResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.DataProtectionManagementClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.models.AzureBackupJobResourceList;
import reactor.core.publisher.Mono;

public final class JobsClientImpl
implements JobsClient {
    private final JobsService service;
    private final DataProtectionManagementClientImpl client;

    JobsClientImpl(DataProtectionManagementClientImpl client) {
        this.service = (JobsService)RestProxy.create(JobsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AzureBackupJobResourceInner>> getWithResponseAsync(String resourceGroupName, String vaultName, String jobId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, jobId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AzureBackupJobResourceInner> getAsync(String resourceGroupName, String vaultName, String jobId) {
        return this.getWithResponseAsync(resourceGroupName, vaultName, jobId).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AzureBackupJobResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AzureBackupJobResourceInner> getWithResponse(String resourceGroupName, String vaultName, String jobId, Context context) {
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, jobId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AzureBackupJobResourceInner get(String resourceGroupName, String vaultName, String jobId) {
        return (AzureBackupJobResourceInner)((Object)this.getWithResponse(resourceGroupName, vaultName, jobId, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AzureBackupJobResourceInner>> listSinglePageAsync(String resourceGroupName, String vaultName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureBackupJobResourceList)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AzureBackupJobResourceInner> listAsync(String resourceGroupName, String vaultName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, vaultName));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AzureBackupJobResourceInner> listSinglePage(String resourceGroupName, String vaultName) {
        String accept = "application/json";
        Response<AzureBackupJobResourceList> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureBackupJobResourceList)res.getValue()).value(), null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AzureBackupJobResourceInner> listSinglePage(String resourceGroupName, String vaultName, Context context) {
        String accept = "application/json";
        Response<AzureBackupJobResourceList> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureBackupJobResourceList)res.getValue()).value(), null, null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AzureBackupJobResourceInner> list(String resourceGroupName, String vaultName) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, vaultName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AzureBackupJobResourceInner> list(String resourceGroupName, String vaultName, Context context) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, vaultName, context));
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="DataProtectionManagementClientJobs")
    public static interface JobsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupJobs/{jobId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AzureBackupJobResourceInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="vaultName") String var5, @PathParam(value="jobId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupJobs/{jobId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AzureBackupJobResourceInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="vaultName") String var5, @PathParam(value="jobId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupJobs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AzureBackupJobResourceList>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="vaultName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupJobs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AzureBackupJobResourceList> listSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="vaultName") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

