/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dataprotection.DataProtectionManager;
import com.azure.resourcemanager.dataprotection.fluent.FetchCrossRegionRestoreJobsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.AzureBackupJobResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.AzureBackupJobResourceImpl;
import com.azure.resourcemanager.dataprotection.models.AzureBackupJobResource;
import com.azure.resourcemanager.dataprotection.models.CrossRegionRestoreJobRequest;
import com.azure.resourcemanager.dataprotection.models.FetchCrossRegionRestoreJobs;

public final class FetchCrossRegionRestoreJobsImpl
implements FetchCrossRegionRestoreJobs {
    private static final ClientLogger LOGGER = new ClientLogger(FetchCrossRegionRestoreJobsImpl.class);
    private final FetchCrossRegionRestoreJobsClient innerClient;
    private final DataProtectionManager serviceManager;

    public FetchCrossRegionRestoreJobsImpl(FetchCrossRegionRestoreJobsClient innerClient, DataProtectionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<AzureBackupJobResource> getWithResponse(String resourceGroupName, String location, CrossRegionRestoreJobRequest parameters, Context context) {
        Response<AzureBackupJobResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, location, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AzureBackupJobResourceImpl((AzureBackupJobResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AzureBackupJobResource get(String resourceGroupName, String location, CrossRegionRestoreJobRequest parameters) {
        AzureBackupJobResourceInner inner = this.serviceClient().get(resourceGroupName, location, parameters);
        if (inner != null) {
            return new AzureBackupJobResourceImpl(inner, this.manager());
        }
        return null;
    }

    private FetchCrossRegionRestoreJobsClient serviceClient() {
        return this.innerClient;
    }

    private DataProtectionManager manager() {
        return this.serviceManager;
    }
}

