/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dataprotection.DataProtectionManager;
import com.azure.resourcemanager.dataprotection.fluent.BackupVaultsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.BackupVaultResourceInner;
import com.azure.resourcemanager.dataprotection.fluent.models.CheckNameAvailabilityResultInner;
import com.azure.resourcemanager.dataprotection.implementation.BackupVaultResourceImpl;
import com.azure.resourcemanager.dataprotection.implementation.CheckNameAvailabilityResultImpl;
import com.azure.resourcemanager.dataprotection.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dataprotection.models.BackupVaultResource;
import com.azure.resourcemanager.dataprotection.models.BackupVaults;
import com.azure.resourcemanager.dataprotection.models.CheckNameAvailabilityRequest;
import com.azure.resourcemanager.dataprotection.models.CheckNameAvailabilityResult;

public final class BackupVaultsImpl
implements BackupVaults {
    private static final ClientLogger LOGGER = new ClientLogger(BackupVaultsImpl.class);
    private final BackupVaultsClient innerClient;
    private final DataProtectionManager serviceManager;

    public BackupVaultsImpl(BackupVaultsClient innerClient, DataProtectionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<BackupVaultResource> getByResourceGroupWithResponse(String resourceGroupName, String vaultName, Context context) {
        Response<BackupVaultResourceInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, vaultName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BackupVaultResourceImpl((BackupVaultResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public BackupVaultResource getByResourceGroup(String resourceGroupName, String vaultName) {
        BackupVaultResourceInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, vaultName);
        if (inner != null) {
            return new BackupVaultResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String vaultName) {
        this.serviceClient().delete(resourceGroupName, vaultName);
    }

    @Override
    public void delete(String resourceGroupName, String vaultName, Context context) {
        this.serviceClient().delete(resourceGroupName, vaultName, context);
    }

    @Override
    public PagedIterable<BackupVaultResource> list() {
        PagedIterable<BackupVaultResourceInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BackupVaultResourceImpl((BackupVaultResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BackupVaultResource> list(Context context) {
        PagedIterable<BackupVaultResourceInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BackupVaultResourceImpl((BackupVaultResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BackupVaultResource> listByResourceGroup(String resourceGroupName) {
        PagedIterable<BackupVaultResourceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BackupVaultResourceImpl((BackupVaultResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BackupVaultResource> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<BackupVaultResourceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BackupVaultResourceImpl((BackupVaultResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<CheckNameAvailabilityResult> checkNameAvailabilityWithResponse(String resourceGroupName, String location, CheckNameAvailabilityRequest parameters, Context context) {
        Response<CheckNameAvailabilityResultInner> inner = this.serviceClient().checkNameAvailabilityWithResponse(resourceGroupName, location, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CheckNameAvailabilityResultImpl((CheckNameAvailabilityResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CheckNameAvailabilityResult checkNameAvailability(String resourceGroupName, String location, CheckNameAvailabilityRequest parameters) {
        CheckNameAvailabilityResultInner inner = this.serviceClient().checkNameAvailability(resourceGroupName, location, parameters);
        if (inner != null) {
            return new CheckNameAvailabilityResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public BackupVaultResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String vaultName = ResourceManagerUtils.getValueFromIdByName(id, "backupVaults");
        if (vaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupVaults'.", id)));
        }
        return (BackupVaultResource)this.getByResourceGroupWithResponse(resourceGroupName, vaultName, Context.NONE).getValue();
    }

    @Override
    public Response<BackupVaultResource> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String vaultName = ResourceManagerUtils.getValueFromIdByName(id, "backupVaults");
        if (vaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupVaults'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, vaultName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String vaultName = ResourceManagerUtils.getValueFromIdByName(id, "backupVaults");
        if (vaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupVaults'.", id)));
        }
        this.delete(resourceGroupName, vaultName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String vaultName = ResourceManagerUtils.getValueFromIdByName(id, "backupVaults");
        if (vaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupVaults'.", id)));
        }
        this.delete(resourceGroupName, vaultName, context);
    }

    private BackupVaultsClient serviceClient() {
        return this.innerClient;
    }

    private DataProtectionManager manager() {
        return this.serviceManager;
    }

    @Override
    public BackupVaultResourceImpl define(String name) {
        return new BackupVaultResourceImpl(name, this.manager());
    }
}

