/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.BackupVault;
import com.azure.resourcemanager.dataprotection.models.DppIdentityDetails;
import java.io.IOException;
import java.util.Map;

public final class BackupVaultResourceInner
extends Resource {
    private BackupVault properties;
    private DppIdentityDetails identity;
    private String etag;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public BackupVault properties() {
        return this.properties;
    }

    public BackupVaultResourceInner withProperties(BackupVault properties) {
        this.properties = properties;
        return this;
    }

    public DppIdentityDetails identity() {
        return this.identity;
    }

    public BackupVaultResourceInner withIdentity(DppIdentityDetails identity) {
        this.identity = identity;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public BackupVaultResourceInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public BackupVaultResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public BackupVaultResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeStringField("eTag", this.etag);
        return jsonWriter.writeEndObject();
    }

    public static BackupVaultResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (BackupVaultResourceInner)((Object)jsonReader.readObject(reader -> {
            BackupVaultResourceInner deserializedBackupVaultResourceInner = new BackupVaultResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBackupVaultResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBackupVaultResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBackupVaultResourceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedBackupVaultResourceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedBackupVaultResourceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBackupVaultResourceInner.properties = BackupVault.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedBackupVaultResourceInner.identity = DppIdentityDetails.fromJson(reader);
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedBackupVaultResourceInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedBackupVaultResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupVaultResourceInner;
        }));
    }
}

