/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.BackupSchedule;
import com.azure.resourcemanager.dataprotection.models.TaggingCriteria;
import com.azure.resourcemanager.dataprotection.models.TriggerContext;
import java.io.IOException;
import java.util.List;

public final class ScheduleBasedTriggerContext
extends TriggerContext {
    private String objectType = "ScheduleBasedTriggerContext";
    private BackupSchedule schedule;
    private List<TaggingCriteria> taggingCriteria;
    private static final ClientLogger LOGGER = new ClientLogger(ScheduleBasedTriggerContext.class);

    @Override
    public String objectType() {
        return this.objectType;
    }

    public BackupSchedule schedule() {
        return this.schedule;
    }

    public ScheduleBasedTriggerContext withSchedule(BackupSchedule schedule) {
        this.schedule = schedule;
        return this;
    }

    public List<TaggingCriteria> taggingCriteria() {
        return this.taggingCriteria;
    }

    public ScheduleBasedTriggerContext withTaggingCriteria(List<TaggingCriteria> taggingCriteria) {
        this.taggingCriteria = taggingCriteria;
        return this;
    }

    @Override
    public void validate() {
        if (this.schedule() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property schedule in model ScheduleBasedTriggerContext"));
        }
        this.schedule().validate();
        if (this.taggingCriteria() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property taggingCriteria in model ScheduleBasedTriggerContext"));
        }
        this.taggingCriteria().forEach(e -> e.validate());
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("schedule", (JsonSerializable)this.schedule);
        jsonWriter.writeArrayField("taggingCriteria", this.taggingCriteria, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("objectType", this.objectType);
        return jsonWriter.writeEndObject();
    }

    public static ScheduleBasedTriggerContext fromJson(JsonReader jsonReader) throws IOException {
        return (ScheduleBasedTriggerContext)jsonReader.readObject(reader -> {
            ScheduleBasedTriggerContext deserializedScheduleBasedTriggerContext = new ScheduleBasedTriggerContext();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("schedule".equals(fieldName)) {
                    deserializedScheduleBasedTriggerContext.schedule = BackupSchedule.fromJson(reader);
                    continue;
                }
                if ("taggingCriteria".equals(fieldName)) {
                    List taggingCriteria;
                    deserializedScheduleBasedTriggerContext.taggingCriteria = taggingCriteria = reader.readArray(reader1 -> TaggingCriteria.fromJson(reader1));
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedScheduleBasedTriggerContext.objectType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScheduleBasedTriggerContext;
        });
    }
}

