/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.ItemLevelRestoreTargetInfo;
import com.azure.resourcemanager.dataprotection.models.RecoveryOption;
import com.azure.resourcemanager.dataprotection.models.RestoreFilesTargetInfo;
import com.azure.resourcemanager.dataprotection.models.RestoreTargetInfo;
import java.io.IOException;

public class RestoreTargetInfoBase
implements JsonSerializable<RestoreTargetInfoBase> {
    private String objectType = "RestoreTargetInfoBase";
    private RecoveryOption recoveryOption;
    private String restoreLocation;
    private static final ClientLogger LOGGER = new ClientLogger(RestoreTargetInfoBase.class);

    public String objectType() {
        return this.objectType;
    }

    public RecoveryOption recoveryOption() {
        return this.recoveryOption;
    }

    public RestoreTargetInfoBase withRecoveryOption(RecoveryOption recoveryOption) {
        this.recoveryOption = recoveryOption;
        return this;
    }

    public String restoreLocation() {
        return this.restoreLocation;
    }

    public RestoreTargetInfoBase withRestoreLocation(String restoreLocation) {
        this.restoreLocation = restoreLocation;
        return this;
    }

    public void validate() {
        if (this.recoveryOption() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property recoveryOption in model RestoreTargetInfoBase"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recoveryOption", this.recoveryOption == null ? null : this.recoveryOption.toString());
        jsonWriter.writeStringField("objectType", this.objectType);
        jsonWriter.writeStringField("restoreLocation", this.restoreLocation);
        return jsonWriter.writeEndObject();
    }

    public static RestoreTargetInfoBase fromJson(JsonReader jsonReader) throws IOException {
        return (RestoreTargetInfoBase)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                RestoreTargetInfoBase restoreTargetInfoBase;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("objectType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("ItemLevelRestoreTargetInfo".equals(discriminatorValue)) {
                    restoreTargetInfoBase = ItemLevelRestoreTargetInfo.fromJson(readerToUse.reset());
                    return restoreTargetInfoBase;
                }
                if ("RestoreFilesTargetInfo".equals(discriminatorValue)) {
                    restoreTargetInfoBase = RestoreFilesTargetInfo.fromJson(readerToUse.reset());
                    return restoreTargetInfoBase;
                }
                if ("RestoreTargetInfo".equals(discriminatorValue)) {
                    restoreTargetInfoBase = RestoreTargetInfo.fromJson(readerToUse.reset());
                    return restoreTargetInfoBase;
                }
                restoreTargetInfoBase = RestoreTargetInfoBase.fromJsonKnownDiscriminator(readerToUse.reset());
                return restoreTargetInfoBase;
            }
        });
    }

    static RestoreTargetInfoBase fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (RestoreTargetInfoBase)jsonReader.readObject(reader -> {
            RestoreTargetInfoBase deserializedRestoreTargetInfoBase = new RestoreTargetInfoBase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recoveryOption".equals(fieldName)) {
                    deserializedRestoreTargetInfoBase.recoveryOption = RecoveryOption.fromString(reader.getString());
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedRestoreTargetInfoBase.objectType = reader.getString();
                    continue;
                }
                if ("restoreLocation".equals(fieldName)) {
                    deserializedRestoreTargetInfoBase.restoreLocation = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestoreTargetInfoBase;
        });
    }
}

