/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.CrossRegionRestoreSettings;
import com.azure.resourcemanager.dataprotection.models.CrossSubscriptionRestoreSettings;
import java.io.IOException;

public final class FeatureSettings
implements JsonSerializable<FeatureSettings> {
    private CrossSubscriptionRestoreSettings crossSubscriptionRestoreSettings;
    private CrossRegionRestoreSettings crossRegionRestoreSettings;

    public CrossSubscriptionRestoreSettings crossSubscriptionRestoreSettings() {
        return this.crossSubscriptionRestoreSettings;
    }

    public FeatureSettings withCrossSubscriptionRestoreSettings(CrossSubscriptionRestoreSettings crossSubscriptionRestoreSettings) {
        this.crossSubscriptionRestoreSettings = crossSubscriptionRestoreSettings;
        return this;
    }

    public CrossRegionRestoreSettings crossRegionRestoreSettings() {
        return this.crossRegionRestoreSettings;
    }

    public FeatureSettings withCrossRegionRestoreSettings(CrossRegionRestoreSettings crossRegionRestoreSettings) {
        this.crossRegionRestoreSettings = crossRegionRestoreSettings;
        return this;
    }

    public void validate() {
        if (this.crossSubscriptionRestoreSettings() != null) {
            this.crossSubscriptionRestoreSettings().validate();
        }
        if (this.crossRegionRestoreSettings() != null) {
            this.crossRegionRestoreSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("crossSubscriptionRestoreSettings", (JsonSerializable)this.crossSubscriptionRestoreSettings);
        jsonWriter.writeJsonField("crossRegionRestoreSettings", (JsonSerializable)this.crossRegionRestoreSettings);
        return jsonWriter.writeEndObject();
    }

    public static FeatureSettings fromJson(JsonReader jsonReader) throws IOException {
        return (FeatureSettings)jsonReader.readObject(reader -> {
            FeatureSettings deserializedFeatureSettings = new FeatureSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("crossSubscriptionRestoreSettings".equals(fieldName)) {
                    deserializedFeatureSettings.crossSubscriptionRestoreSettings = CrossSubscriptionRestoreSettings.fromJson(reader);
                    continue;
                }
                if ("crossRegionRestoreSettings".equals(fieldName)) {
                    deserializedFeatureSettings.crossRegionRestoreSettings = CrossRegionRestoreSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFeatureSettings;
        });
    }
}

