/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BackupSchedule
implements JsonSerializable<BackupSchedule> {
    private List<String> repeatingTimeIntervals;
    private String timeZone;
    private static final ClientLogger LOGGER = new ClientLogger(BackupSchedule.class);

    public List<String> repeatingTimeIntervals() {
        return this.repeatingTimeIntervals;
    }

    public BackupSchedule withRepeatingTimeIntervals(List<String> repeatingTimeIntervals) {
        this.repeatingTimeIntervals = repeatingTimeIntervals;
        return this;
    }

    public String timeZone() {
        return this.timeZone;
    }

    public BackupSchedule withTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public void validate() {
        if (this.repeatingTimeIntervals() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property repeatingTimeIntervals in model BackupSchedule"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("repeatingTimeIntervals", this.repeatingTimeIntervals, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("timeZone", this.timeZone);
        return jsonWriter.writeEndObject();
    }

    public static BackupSchedule fromJson(JsonReader jsonReader) throws IOException {
        return (BackupSchedule)jsonReader.readObject(reader -> {
            BackupSchedule deserializedBackupSchedule = new BackupSchedule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("repeatingTimeIntervals".equals(fieldName)) {
                    List repeatingTimeIntervals;
                    deserializedBackupSchedule.repeatingTimeIntervals = repeatingTimeIntervals = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("timeZone".equals(fieldName)) {
                    deserializedBackupSchedule.timeZone = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupSchedule;
        });
    }
}

