/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.BaseBackupPolicy;
import com.azure.resourcemanager.dataprotection.models.BasePolicyRule;
import java.io.IOException;
import java.util.List;

public final class BackupPolicy
extends BaseBackupPolicy {
    private String objectType = "BackupPolicy";
    private List<BasePolicyRule> policyRules;
    private static final ClientLogger LOGGER = new ClientLogger(BackupPolicy.class);

    @Override
    public String objectType() {
        return this.objectType;
    }

    public List<BasePolicyRule> policyRules() {
        return this.policyRules;
    }

    public BackupPolicy withPolicyRules(List<BasePolicyRule> policyRules) {
        this.policyRules = policyRules;
        return this;
    }

    @Override
    public BackupPolicy withDatasourceTypes(List<String> datasourceTypes) {
        super.withDatasourceTypes(datasourceTypes);
        return this;
    }

    @Override
    public void validate() {
        if (this.policyRules() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property policyRules in model BackupPolicy"));
        }
        this.policyRules().forEach(e -> e.validate());
        if (this.datasourceTypes() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property datasourceTypes in model BackupPolicy"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("datasourceTypes", this.datasourceTypes(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("policyRules", this.policyRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("objectType", this.objectType);
        return jsonWriter.writeEndObject();
    }

    public static BackupPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (BackupPolicy)jsonReader.readObject(reader -> {
            BackupPolicy deserializedBackupPolicy = new BackupPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("datasourceTypes".equals(fieldName)) {
                    List datasourceTypes = reader.readArray(reader1 -> reader1.getString());
                    deserializedBackupPolicy.withDatasourceTypes(datasourceTypes);
                    continue;
                }
                if ("policyRules".equals(fieldName)) {
                    List policyRules;
                    deserializedBackupPolicy.policyRules = policyRules = reader.readArray(reader1 -> BasePolicyRule.fromJson(reader1));
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedBackupPolicy.objectType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupPolicy;
        });
    }
}

