/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.RehydrationPriority;
import java.io.IOException;

public final class AzureBackupRehydrationRequest
implements JsonSerializable<AzureBackupRehydrationRequest> {
    private String recoveryPointId;
    private RehydrationPriority rehydrationPriority;
    private String rehydrationRetentionDuration;
    private static final ClientLogger LOGGER = new ClientLogger(AzureBackupRehydrationRequest.class);

    public String recoveryPointId() {
        return this.recoveryPointId;
    }

    public AzureBackupRehydrationRequest withRecoveryPointId(String recoveryPointId) {
        this.recoveryPointId = recoveryPointId;
        return this;
    }

    public RehydrationPriority rehydrationPriority() {
        return this.rehydrationPriority;
    }

    public AzureBackupRehydrationRequest withRehydrationPriority(RehydrationPriority rehydrationPriority) {
        this.rehydrationPriority = rehydrationPriority;
        return this;
    }

    public String rehydrationRetentionDuration() {
        return this.rehydrationRetentionDuration;
    }

    public AzureBackupRehydrationRequest withRehydrationRetentionDuration(String rehydrationRetentionDuration) {
        this.rehydrationRetentionDuration = rehydrationRetentionDuration;
        return this;
    }

    public void validate() {
        if (this.recoveryPointId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property recoveryPointId in model AzureBackupRehydrationRequest"));
        }
        if (this.rehydrationRetentionDuration() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property rehydrationRetentionDuration in model AzureBackupRehydrationRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recoveryPointId", this.recoveryPointId);
        jsonWriter.writeStringField("rehydrationRetentionDuration", this.rehydrationRetentionDuration);
        jsonWriter.writeStringField("rehydrationPriority", this.rehydrationPriority == null ? null : this.rehydrationPriority.toString());
        return jsonWriter.writeEndObject();
    }

    public static AzureBackupRehydrationRequest fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBackupRehydrationRequest)jsonReader.readObject(reader -> {
            AzureBackupRehydrationRequest deserializedAzureBackupRehydrationRequest = new AzureBackupRehydrationRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recoveryPointId".equals(fieldName)) {
                    deserializedAzureBackupRehydrationRequest.recoveryPointId = reader.getString();
                    continue;
                }
                if ("rehydrationRetentionDuration".equals(fieldName)) {
                    deserializedAzureBackupRehydrationRequest.rehydrationRetentionDuration = reader.getString();
                    continue;
                }
                if ("rehydrationPriority".equals(fieldName)) {
                    deserializedAzureBackupRehydrationRequest.rehydrationPriority = RehydrationPriority.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureBackupRehydrationRequest;
        });
    }
}

