/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.AzureBackupRestoreRequest;
import com.azure.resourcemanager.dataprotection.models.AzureBackupRestoreWithRehydrationRequest;
import com.azure.resourcemanager.dataprotection.models.IdentityDetails;
import com.azure.resourcemanager.dataprotection.models.RestoreTargetInfoBase;
import com.azure.resourcemanager.dataprotection.models.SourceDataStoreType;
import java.io.IOException;
import java.util.List;

public class AzureBackupRecoveryPointBasedRestoreRequest
extends AzureBackupRestoreRequest {
    private String objectType = "AzureBackupRecoveryPointBasedRestoreRequest";
    private String recoveryPointId;
    private static final ClientLogger LOGGER = new ClientLogger(AzureBackupRecoveryPointBasedRestoreRequest.class);

    @Override
    public String objectType() {
        return this.objectType;
    }

    public String recoveryPointId() {
        return this.recoveryPointId;
    }

    public AzureBackupRecoveryPointBasedRestoreRequest withRecoveryPointId(String recoveryPointId) {
        this.recoveryPointId = recoveryPointId;
        return this;
    }

    @Override
    public AzureBackupRecoveryPointBasedRestoreRequest withRestoreTargetInfo(RestoreTargetInfoBase restoreTargetInfo) {
        super.withRestoreTargetInfo(restoreTargetInfo);
        return this;
    }

    @Override
    public AzureBackupRecoveryPointBasedRestoreRequest withSourceDataStoreType(SourceDataStoreType sourceDataStoreType) {
        super.withSourceDataStoreType(sourceDataStoreType);
        return this;
    }

    @Override
    public AzureBackupRecoveryPointBasedRestoreRequest withSourceResourceId(String sourceResourceId) {
        super.withSourceResourceId(sourceResourceId);
        return this;
    }

    @Override
    public AzureBackupRecoveryPointBasedRestoreRequest withResourceGuardOperationRequests(List<String> resourceGuardOperationRequests) {
        super.withResourceGuardOperationRequests(resourceGuardOperationRequests);
        return this;
    }

    @Override
    public AzureBackupRecoveryPointBasedRestoreRequest withIdentityDetails(IdentityDetails identityDetails) {
        super.withIdentityDetails(identityDetails);
        return this;
    }

    @Override
    public void validate() {
        if (this.recoveryPointId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property recoveryPointId in model AzureBackupRecoveryPointBasedRestoreRequest"));
        }
        if (this.restoreTargetInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property restoreTargetInfo in model AzureBackupRecoveryPointBasedRestoreRequest"));
        }
        this.restoreTargetInfo().validate();
        if (this.sourceDataStoreType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceDataStoreType in model AzureBackupRecoveryPointBasedRestoreRequest"));
        }
        if (this.identityDetails() != null) {
            this.identityDetails().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("restoreTargetInfo", (JsonSerializable)this.restoreTargetInfo());
        jsonWriter.writeStringField("sourceDataStoreType", this.sourceDataStoreType() == null ? null : this.sourceDataStoreType().toString());
        jsonWriter.writeStringField("sourceResourceId", this.sourceResourceId());
        jsonWriter.writeArrayField("resourceGuardOperationRequests", this.resourceGuardOperationRequests(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identityDetails", (JsonSerializable)this.identityDetails());
        jsonWriter.writeStringField("recoveryPointId", this.recoveryPointId);
        jsonWriter.writeStringField("objectType", this.objectType);
        return jsonWriter.writeEndObject();
    }

    public static AzureBackupRecoveryPointBasedRestoreRequest fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBackupRecoveryPointBasedRestoreRequest)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                AzureBackupRecoveryPointBasedRestoreRequest azureBackupRecoveryPointBasedRestoreRequest;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("objectType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("AzureBackupRestoreWithRehydrationRequest".equals(discriminatorValue)) {
                    azureBackupRecoveryPointBasedRestoreRequest = AzureBackupRestoreWithRehydrationRequest.fromJson(readerToUse.reset());
                    return azureBackupRecoveryPointBasedRestoreRequest;
                }
                azureBackupRecoveryPointBasedRestoreRequest = AzureBackupRecoveryPointBasedRestoreRequest.fromJsonKnownDiscriminator(readerToUse.reset());
                return azureBackupRecoveryPointBasedRestoreRequest;
            }
        });
    }

    static AzureBackupRecoveryPointBasedRestoreRequest fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (AzureBackupRecoveryPointBasedRestoreRequest)jsonReader.readObject(reader -> {
            AzureBackupRecoveryPointBasedRestoreRequest deserializedAzureBackupRecoveryPointBasedRestoreRequest = new AzureBackupRecoveryPointBasedRestoreRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("restoreTargetInfo".equals(fieldName)) {
                    deserializedAzureBackupRecoveryPointBasedRestoreRequest.withRestoreTargetInfo(RestoreTargetInfoBase.fromJson(reader));
                    continue;
                }
                if ("sourceDataStoreType".equals(fieldName)) {
                    deserializedAzureBackupRecoveryPointBasedRestoreRequest.withSourceDataStoreType(SourceDataStoreType.fromString(reader.getString()));
                    continue;
                }
                if ("sourceResourceId".equals(fieldName)) {
                    deserializedAzureBackupRecoveryPointBasedRestoreRequest.withSourceResourceId(reader.getString());
                    continue;
                }
                if ("resourceGuardOperationRequests".equals(fieldName)) {
                    List resourceGuardOperationRequests = reader.readArray(reader1 -> reader1.getString());
                    deserializedAzureBackupRecoveryPointBasedRestoreRequest.withResourceGuardOperationRequests(resourceGuardOperationRequests);
                    continue;
                }
                if ("identityDetails".equals(fieldName)) {
                    deserializedAzureBackupRecoveryPointBasedRestoreRequest.withIdentityDetails(IdentityDetails.fromJson(reader));
                    continue;
                }
                if ("recoveryPointId".equals(fieldName)) {
                    deserializedAzureBackupRecoveryPointBasedRestoreRequest.recoveryPointId = reader.getString();
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedAzureBackupRecoveryPointBasedRestoreRequest.objectType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureBackupRecoveryPointBasedRestoreRequest;
        });
    }
}

