/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.AdhocBasedTaggingCriteria;
import com.azure.resourcemanager.dataprotection.models.TriggerContext;
import java.io.IOException;

public final class AdhocBasedTriggerContext
extends TriggerContext {
    private String objectType = "AdhocBasedTriggerContext";
    private AdhocBasedTaggingCriteria taggingCriteria;
    private static final ClientLogger LOGGER = new ClientLogger(AdhocBasedTriggerContext.class);

    @Override
    public String objectType() {
        return this.objectType;
    }

    public AdhocBasedTaggingCriteria taggingCriteria() {
        return this.taggingCriteria;
    }

    public AdhocBasedTriggerContext withTaggingCriteria(AdhocBasedTaggingCriteria taggingCriteria) {
        this.taggingCriteria = taggingCriteria;
        return this;
    }

    @Override
    public void validate() {
        if (this.taggingCriteria() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property taggingCriteria in model AdhocBasedTriggerContext"));
        }
        this.taggingCriteria().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("taggingCriteria", (JsonSerializable)this.taggingCriteria);
        jsonWriter.writeStringField("objectType", this.objectType);
        return jsonWriter.writeEndObject();
    }

    public static AdhocBasedTriggerContext fromJson(JsonReader jsonReader) throws IOException {
        return (AdhocBasedTriggerContext)jsonReader.readObject(reader -> {
            AdhocBasedTriggerContext deserializedAdhocBasedTriggerContext = new AdhocBasedTriggerContext();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("taggingCriteria".equals(fieldName)) {
                    deserializedAdhocBasedTriggerContext.taggingCriteria = AdhocBasedTaggingCriteria.fromJson(reader);
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedAdhocBasedTriggerContext.objectType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAdhocBasedTriggerContext;
        });
    }
}

