/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dataprotection.DataProtectionManager;
import com.azure.resourcemanager.dataprotection.fluent.ResourceGuardsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.DppBaseResourceInner;
import com.azure.resourcemanager.dataprotection.fluent.models.ResourceGuardResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.DppBaseResourceImpl;
import com.azure.resourcemanager.dataprotection.implementation.ResourceGuardResourceImpl;
import com.azure.resourcemanager.dataprotection.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dataprotection.models.DppBaseResource;
import com.azure.resourcemanager.dataprotection.models.ResourceGuardResource;
import com.azure.resourcemanager.dataprotection.models.ResourceGuards;

public final class ResourceGuardsImpl
implements ResourceGuards {
    private static final ClientLogger LOGGER = new ClientLogger(ResourceGuardsImpl.class);
    private final ResourceGuardsClient innerClient;
    private final DataProtectionManager serviceManager;

    public ResourceGuardsImpl(ResourceGuardsClient innerClient, DataProtectionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ResourceGuardResource> list() {
        PagedIterable<ResourceGuardResourceInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ResourceGuardResourceImpl((ResourceGuardResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ResourceGuardResource> list(Context context) {
        PagedIterable<ResourceGuardResourceInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ResourceGuardResourceImpl((ResourceGuardResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ResourceGuardResource> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ResourceGuardResourceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ResourceGuardResourceImpl((ResourceGuardResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ResourceGuardResource> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ResourceGuardResourceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ResourceGuardResourceImpl((ResourceGuardResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ResourceGuardResource> getByResourceGroupWithResponse(String resourceGroupName, String resourceGuardsName, Context context) {
        Response<ResourceGuardResourceInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, resourceGuardsName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ResourceGuardResourceImpl((ResourceGuardResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ResourceGuardResource getByResourceGroup(String resourceGroupName, String resourceGuardsName) {
        ResourceGuardResourceInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, resourceGuardsName);
        if (inner != null) {
            return new ResourceGuardResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String resourceGroupName, String resourceGuardsName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, resourceGuardsName, context);
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String resourceGuardsName) {
        this.serviceClient().delete(resourceGroupName, resourceGuardsName);
    }

    @Override
    public PagedIterable<DppBaseResource> getDisableSoftDeleteRequestsObjects(String resourceGroupName, String resourceGuardsName) {
        PagedIterable<DppBaseResourceInner> inner = this.serviceClient().getDisableSoftDeleteRequestsObjects(resourceGroupName, resourceGuardsName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DppBaseResourceImpl((DppBaseResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<DppBaseResource> getDisableSoftDeleteRequestsObjects(String resourceGroupName, String resourceGuardsName, Context context) {
        PagedIterable<DppBaseResourceInner> inner = this.serviceClient().getDisableSoftDeleteRequestsObjects(resourceGroupName, resourceGuardsName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DppBaseResourceImpl((DppBaseResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<DppBaseResource> getDeleteResourceGuardProxyRequestsObjects(String resourceGroupName, String resourceGuardsName) {
        PagedIterable<DppBaseResourceInner> inner = this.serviceClient().getDeleteResourceGuardProxyRequestsObjects(resourceGroupName, resourceGuardsName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DppBaseResourceImpl((DppBaseResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<DppBaseResource> getDeleteResourceGuardProxyRequestsObjects(String resourceGroupName, String resourceGuardsName, Context context) {
        PagedIterable<DppBaseResourceInner> inner = this.serviceClient().getDeleteResourceGuardProxyRequestsObjects(resourceGroupName, resourceGuardsName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DppBaseResourceImpl((DppBaseResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<DppBaseResource> getBackupSecurityPinRequestsObjects(String resourceGroupName, String resourceGuardsName) {
        PagedIterable<DppBaseResourceInner> inner = this.serviceClient().getBackupSecurityPinRequestsObjects(resourceGroupName, resourceGuardsName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DppBaseResourceImpl((DppBaseResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<DppBaseResource> getBackupSecurityPinRequestsObjects(String resourceGroupName, String resourceGuardsName, Context context) {
        PagedIterable<DppBaseResourceInner> inner = this.serviceClient().getBackupSecurityPinRequestsObjects(resourceGroupName, resourceGuardsName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DppBaseResourceImpl((DppBaseResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<DppBaseResource> getDeleteProtectedItemRequestsObjects(String resourceGroupName, String resourceGuardsName) {
        PagedIterable<DppBaseResourceInner> inner = this.serviceClient().getDeleteProtectedItemRequestsObjects(resourceGroupName, resourceGuardsName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DppBaseResourceImpl((DppBaseResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<DppBaseResource> getDeleteProtectedItemRequestsObjects(String resourceGroupName, String resourceGuardsName, Context context) {
        PagedIterable<DppBaseResourceInner> inner = this.serviceClient().getDeleteProtectedItemRequestsObjects(resourceGroupName, resourceGuardsName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DppBaseResourceImpl((DppBaseResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<DppBaseResource> getUpdateProtectionPolicyRequestsObjects(String resourceGroupName, String resourceGuardsName) {
        PagedIterable<DppBaseResourceInner> inner = this.serviceClient().getUpdateProtectionPolicyRequestsObjects(resourceGroupName, resourceGuardsName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DppBaseResourceImpl((DppBaseResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<DppBaseResource> getUpdateProtectionPolicyRequestsObjects(String resourceGroupName, String resourceGuardsName, Context context) {
        PagedIterable<DppBaseResourceInner> inner = this.serviceClient().getUpdateProtectionPolicyRequestsObjects(resourceGroupName, resourceGuardsName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DppBaseResourceImpl((DppBaseResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<DppBaseResource> getUpdateProtectedItemRequestsObjects(String resourceGroupName, String resourceGuardsName) {
        PagedIterable<DppBaseResourceInner> inner = this.serviceClient().getUpdateProtectedItemRequestsObjects(resourceGroupName, resourceGuardsName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DppBaseResourceImpl((DppBaseResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<DppBaseResource> getUpdateProtectedItemRequestsObjects(String resourceGroupName, String resourceGuardsName, Context context) {
        PagedIterable<DppBaseResourceInner> inner = this.serviceClient().getUpdateProtectedItemRequestsObjects(resourceGroupName, resourceGuardsName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DppBaseResourceImpl((DppBaseResourceInner)inner1, this.manager()));
    }

    @Override
    public Response<DppBaseResource> getDefaultDisableSoftDeleteRequestsObjectWithResponse(String resourceGroupName, String resourceGuardsName, String requestName, Context context) {
        Response<DppBaseResourceInner> inner = this.serviceClient().getDefaultDisableSoftDeleteRequestsObjectWithResponse(resourceGroupName, resourceGuardsName, requestName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DppBaseResourceImpl((DppBaseResourceInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DppBaseResource getDefaultDisableSoftDeleteRequestsObject(String resourceGroupName, String resourceGuardsName, String requestName) {
        DppBaseResourceInner inner = this.serviceClient().getDefaultDisableSoftDeleteRequestsObject(resourceGroupName, resourceGuardsName, requestName);
        if (inner != null) {
            return new DppBaseResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<DppBaseResource> getDefaultDeleteResourceGuardProxyRequestsObjectWithResponse(String resourceGroupName, String resourceGuardsName, String requestName, Context context) {
        Response<DppBaseResourceInner> inner = this.serviceClient().getDefaultDeleteResourceGuardProxyRequestsObjectWithResponse(resourceGroupName, resourceGuardsName, requestName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DppBaseResourceImpl((DppBaseResourceInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DppBaseResource getDefaultDeleteResourceGuardProxyRequestsObject(String resourceGroupName, String resourceGuardsName, String requestName) {
        DppBaseResourceInner inner = this.serviceClient().getDefaultDeleteResourceGuardProxyRequestsObject(resourceGroupName, resourceGuardsName, requestName);
        if (inner != null) {
            return new DppBaseResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<DppBaseResource> getDefaultBackupSecurityPinRequestsObjectWithResponse(String resourceGroupName, String resourceGuardsName, String requestName, Context context) {
        Response<DppBaseResourceInner> inner = this.serviceClient().getDefaultBackupSecurityPinRequestsObjectWithResponse(resourceGroupName, resourceGuardsName, requestName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DppBaseResourceImpl((DppBaseResourceInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DppBaseResource getDefaultBackupSecurityPinRequestsObject(String resourceGroupName, String resourceGuardsName, String requestName) {
        DppBaseResourceInner inner = this.serviceClient().getDefaultBackupSecurityPinRequestsObject(resourceGroupName, resourceGuardsName, requestName);
        if (inner != null) {
            return new DppBaseResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<DppBaseResource> getDefaultDeleteProtectedItemRequestsObjectWithResponse(String resourceGroupName, String resourceGuardsName, String requestName, Context context) {
        Response<DppBaseResourceInner> inner = this.serviceClient().getDefaultDeleteProtectedItemRequestsObjectWithResponse(resourceGroupName, resourceGuardsName, requestName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DppBaseResourceImpl((DppBaseResourceInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DppBaseResource getDefaultDeleteProtectedItemRequestsObject(String resourceGroupName, String resourceGuardsName, String requestName) {
        DppBaseResourceInner inner = this.serviceClient().getDefaultDeleteProtectedItemRequestsObject(resourceGroupName, resourceGuardsName, requestName);
        if (inner != null) {
            return new DppBaseResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<DppBaseResource> getDefaultUpdateProtectionPolicyRequestsObjectWithResponse(String resourceGroupName, String resourceGuardsName, String requestName, Context context) {
        Response<DppBaseResourceInner> inner = this.serviceClient().getDefaultUpdateProtectionPolicyRequestsObjectWithResponse(resourceGroupName, resourceGuardsName, requestName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DppBaseResourceImpl((DppBaseResourceInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DppBaseResource getDefaultUpdateProtectionPolicyRequestsObject(String resourceGroupName, String resourceGuardsName, String requestName) {
        DppBaseResourceInner inner = this.serviceClient().getDefaultUpdateProtectionPolicyRequestsObject(resourceGroupName, resourceGuardsName, requestName);
        if (inner != null) {
            return new DppBaseResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<DppBaseResource> getDefaultUpdateProtectedItemRequestsObjectWithResponse(String resourceGroupName, String resourceGuardsName, String requestName, Context context) {
        Response<DppBaseResourceInner> inner = this.serviceClient().getDefaultUpdateProtectedItemRequestsObjectWithResponse(resourceGroupName, resourceGuardsName, requestName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DppBaseResourceImpl((DppBaseResourceInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DppBaseResource getDefaultUpdateProtectedItemRequestsObject(String resourceGroupName, String resourceGuardsName, String requestName) {
        DppBaseResourceInner inner = this.serviceClient().getDefaultUpdateProtectedItemRequestsObject(resourceGroupName, resourceGuardsName, requestName);
        if (inner != null) {
            return new DppBaseResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ResourceGuardResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceGuardsName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGuards");
        if (resourceGuardsName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGuards'.", id)));
        }
        return (ResourceGuardResource)this.getByResourceGroupWithResponse(resourceGroupName, resourceGuardsName, Context.NONE).getValue();
    }

    @Override
    public Response<ResourceGuardResource> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceGuardsName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGuards");
        if (resourceGuardsName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGuards'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, resourceGuardsName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceGuardsName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGuards");
        if (resourceGuardsName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGuards'.", id)));
        }
        this.deleteByResourceGroupWithResponse(resourceGroupName, resourceGuardsName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceGuardsName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGuards");
        if (resourceGuardsName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGuards'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(resourceGroupName, resourceGuardsName, context);
    }

    private ResourceGuardsClient serviceClient() {
        return this.innerClient;
    }

    private DataProtectionManager manager() {
        return this.serviceManager;
    }

    @Override
    public ResourceGuardResourceImpl define(String name) {
        return new ResourceGuardResourceImpl(name, this.manager());
    }
}

