/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dataprotection.DataProtectionManager;
import com.azure.resourcemanager.dataprotection.fluent.RecoveryPointsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.AzureBackupRecoveryPointResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.AzureBackupRecoveryPointResourceImpl;
import com.azure.resourcemanager.dataprotection.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dataprotection.models.AzureBackupRecoveryPointResource;
import com.azure.resourcemanager.dataprotection.models.RecoveryPoints;

public final class RecoveryPointsImpl
implements RecoveryPoints {
    private static final ClientLogger LOGGER = new ClientLogger(RecoveryPointsImpl.class);
    private final RecoveryPointsClient innerClient;
    private final DataProtectionManager serviceManager;

    public RecoveryPointsImpl(RecoveryPointsClient innerClient, DataProtectionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<AzureBackupRecoveryPointResource> list(String resourceGroupName, String vaultName, String backupInstanceName) {
        PagedIterable<AzureBackupRecoveryPointResourceInner> inner = this.serviceClient().list(resourceGroupName, vaultName, backupInstanceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AzureBackupRecoveryPointResourceImpl((AzureBackupRecoveryPointResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AzureBackupRecoveryPointResource> list(String resourceGroupName, String vaultName, String backupInstanceName, String filter, String skipToken, Context context) {
        PagedIterable<AzureBackupRecoveryPointResourceInner> inner = this.serviceClient().list(resourceGroupName, vaultName, backupInstanceName, filter, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AzureBackupRecoveryPointResourceImpl((AzureBackupRecoveryPointResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<AzureBackupRecoveryPointResource> getWithResponse(String resourceGroupName, String vaultName, String backupInstanceName, String recoveryPointId, Context context) {
        Response<AzureBackupRecoveryPointResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, vaultName, backupInstanceName, recoveryPointId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AzureBackupRecoveryPointResourceImpl((AzureBackupRecoveryPointResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AzureBackupRecoveryPointResource get(String resourceGroupName, String vaultName, String backupInstanceName, String recoveryPointId) {
        AzureBackupRecoveryPointResourceInner inner = this.serviceClient().get(resourceGroupName, vaultName, backupInstanceName, recoveryPointId);
        if (inner != null) {
            return new AzureBackupRecoveryPointResourceImpl(inner, this.manager());
        }
        return null;
    }

    private RecoveryPointsClient serviceClient() {
        return this.innerClient;
    }

    private DataProtectionManager manager() {
        return this.serviceManager;
    }
}

