/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dataprotection.DataProtectionManager;
import com.azure.resourcemanager.dataprotection.fluent.FetchSecondaryRecoveryPointsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.AzureBackupRecoveryPointResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.AzureBackupRecoveryPointResourceImpl;
import com.azure.resourcemanager.dataprotection.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dataprotection.models.AzureBackupRecoveryPointResource;
import com.azure.resourcemanager.dataprotection.models.FetchSecondaryRPsRequestParameters;
import com.azure.resourcemanager.dataprotection.models.FetchSecondaryRecoveryPoints;

public final class FetchSecondaryRecoveryPointsImpl
implements FetchSecondaryRecoveryPoints {
    private static final ClientLogger LOGGER = new ClientLogger(FetchSecondaryRecoveryPointsImpl.class);
    private final FetchSecondaryRecoveryPointsClient innerClient;
    private final DataProtectionManager serviceManager;

    public FetchSecondaryRecoveryPointsImpl(FetchSecondaryRecoveryPointsClient innerClient, DataProtectionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<AzureBackupRecoveryPointResource> list(String resourceGroupName, String location, FetchSecondaryRPsRequestParameters parameters) {
        PagedIterable<AzureBackupRecoveryPointResourceInner> inner = this.serviceClient().list(resourceGroupName, location, parameters);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AzureBackupRecoveryPointResourceImpl((AzureBackupRecoveryPointResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AzureBackupRecoveryPointResource> list(String resourceGroupName, String location, FetchSecondaryRPsRequestParameters parameters, String filter, String skipToken, Context context) {
        PagedIterable<AzureBackupRecoveryPointResourceInner> inner = this.serviceClient().list(resourceGroupName, location, parameters, filter, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AzureBackupRecoveryPointResourceImpl((AzureBackupRecoveryPointResourceInner)((Object)inner1), this.manager()));
    }

    private FetchSecondaryRecoveryPointsClient serviceClient() {
        return this.innerClient;
    }

    private DataProtectionManager manager() {
        return this.serviceManager;
    }
}

