/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dataprotection.fluent.ExportJobsClient;
import com.azure.resourcemanager.dataprotection.implementation.DataProtectionClientImpl;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ExportJobsClientImpl
implements ExportJobsClient {
    private final ExportJobsService service;
    private final DataProtectionClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(ExportJobsClientImpl.class);

    ExportJobsClientImpl(DataProtectionClientImpl client) {
        this.service = (ExportJobsService)RestProxy.create(ExportJobsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> triggerWithResponseAsync(String resourceGroupName, String vaultName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.trigger(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> triggerWithResponse(String resourceGroupName, String vaultName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.triggerSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> triggerWithResponse(String resourceGroupName, String vaultName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.triggerSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginTriggerAsync(String resourceGroupName, String vaultName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.triggerWithResponseAsync(resourceGroupName, vaultName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginTrigger(String resourceGroupName, String vaultName) {
        Response<BinaryData> response = this.triggerWithResponse(resourceGroupName, vaultName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginTrigger(String resourceGroupName, String vaultName, Context context) {
        Response<BinaryData> response = this.triggerWithResponse(resourceGroupName, vaultName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> triggerAsync(String resourceGroupName, String vaultName) {
        return this.beginTriggerAsync(resourceGroupName, vaultName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void trigger(String resourceGroupName, String vaultName) {
        this.beginTrigger(resourceGroupName, vaultName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void trigger(String resourceGroupName, String vaultName, Context context) {
        this.beginTrigger(resourceGroupName, vaultName, context).getFinalResult();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DataProtectionClientExportJobs")
    public static interface ExportJobsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/exportBackupJobs")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> trigger(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="vaultName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/exportBackupJobs")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> triggerSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="vaultName") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

