/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dataprotection.fluent.DppResourceGuardProxiesClient;
import com.azure.resourcemanager.dataprotection.fluent.models.ResourceGuardProxyBaseResourceInner;
import com.azure.resourcemanager.dataprotection.fluent.models.UnlockDeleteResponseInner;
import com.azure.resourcemanager.dataprotection.implementation.DataProtectionClientImpl;
import com.azure.resourcemanager.dataprotection.models.ResourceGuardProxyBaseResourceList;
import com.azure.resourcemanager.dataprotection.models.UnlockDeleteRequest;
import reactor.core.publisher.Mono;

public final class DppResourceGuardProxiesClientImpl
implements DppResourceGuardProxiesClient {
    private final DppResourceGuardProxiesService service;
    private final DataProtectionClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(DppResourceGuardProxiesClientImpl.class);

    DppResourceGuardProxiesClientImpl(DataProtectionClientImpl client) {
        this.service = (DppResourceGuardProxiesService)RestProxy.create(DppResourceGuardProxiesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceGuardProxyBaseResourceInner>> listSinglePageAsync(String resourceGroupName, String vaultName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, vaultName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceGuardProxyBaseResourceList)res.getValue()).value(), ((ResourceGuardProxyBaseResourceList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ResourceGuardProxyBaseResourceInner> listAsync(String resourceGroupName, String vaultName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, vaultName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ResourceGuardProxyBaseResourceInner> listSinglePage(String resourceGroupName, String vaultName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ResourceGuardProxyBaseResourceList> res = this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, vaultName, this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceGuardProxyBaseResourceList)res.getValue()).value(), ((ResourceGuardProxyBaseResourceList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ResourceGuardProxyBaseResourceInner> listSinglePage(String resourceGroupName, String vaultName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ResourceGuardProxyBaseResourceList> res = this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, vaultName, this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceGuardProxyBaseResourceList)res.getValue()).value(), ((ResourceGuardProxyBaseResourceList)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ResourceGuardProxyBaseResourceInner> list(String resourceGroupName, String vaultName) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, vaultName), nextLink -> this.listNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ResourceGuardProxyBaseResourceInner> list(String resourceGroupName, String vaultName, Context context) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, vaultName, context), nextLink -> this.listNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ResourceGuardProxyBaseResourceInner>> getWithResponseAsync(String resourceGroupName, String vaultName, String resourceGuardProxyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (resourceGuardProxyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGuardProxyName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, vaultName, resourceGuardProxyName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ResourceGuardProxyBaseResourceInner> getAsync(String resourceGroupName, String vaultName, String resourceGuardProxyName) {
        return this.getWithResponseAsync(resourceGroupName, vaultName, resourceGuardProxyName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ResourceGuardProxyBaseResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ResourceGuardProxyBaseResourceInner> getWithResponse(String resourceGroupName, String vaultName, String resourceGuardProxyName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (resourceGuardProxyName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGuardProxyName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, vaultName, resourceGuardProxyName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResourceGuardProxyBaseResourceInner get(String resourceGroupName, String vaultName, String resourceGuardProxyName) {
        return (ResourceGuardProxyBaseResourceInner)((Object)this.getWithResponse(resourceGroupName, vaultName, resourceGuardProxyName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ResourceGuardProxyBaseResourceInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String vaultName, String resourceGuardProxyName, ResourceGuardProxyBaseResourceInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (resourceGuardProxyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGuardProxyName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, vaultName, resourceGuardProxyName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ResourceGuardProxyBaseResourceInner> createOrUpdateAsync(String resourceGroupName, String vaultName, String resourceGuardProxyName, ResourceGuardProxyBaseResourceInner parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, vaultName, resourceGuardProxyName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ResourceGuardProxyBaseResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ResourceGuardProxyBaseResourceInner> createOrUpdateWithResponse(String resourceGroupName, String vaultName, String resourceGuardProxyName, ResourceGuardProxyBaseResourceInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (resourceGuardProxyName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGuardProxyName is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, vaultName, resourceGuardProxyName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResourceGuardProxyBaseResourceInner createOrUpdate(String resourceGroupName, String vaultName, String resourceGuardProxyName, ResourceGuardProxyBaseResourceInner parameters) {
        return (ResourceGuardProxyBaseResourceInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, vaultName, resourceGuardProxyName, parameters, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String vaultName, String resourceGuardProxyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (resourceGuardProxyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGuardProxyName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, vaultName, resourceGuardProxyName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String vaultName, String resourceGuardProxyName) {
        return this.deleteWithResponseAsync(resourceGroupName, vaultName, resourceGuardProxyName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String vaultName, String resourceGuardProxyName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (resourceGuardProxyName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGuardProxyName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, vaultName, resourceGuardProxyName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String vaultName, String resourceGuardProxyName) {
        this.deleteWithResponse(resourceGroupName, vaultName, resourceGuardProxyName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<UnlockDeleteResponseInner>> unlockDeleteWithResponseAsync(String resourceGroupName, String vaultName, String resourceGuardProxyName, UnlockDeleteRequest parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (resourceGuardProxyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGuardProxyName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.unlockDelete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, vaultName, resourceGuardProxyName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<UnlockDeleteResponseInner> unlockDeleteAsync(String resourceGroupName, String vaultName, String resourceGuardProxyName, UnlockDeleteRequest parameters) {
        return this.unlockDeleteWithResponseAsync(resourceGroupName, vaultName, resourceGuardProxyName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((UnlockDeleteResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<UnlockDeleteResponseInner> unlockDeleteWithResponse(String resourceGroupName, String vaultName, String resourceGuardProxyName, UnlockDeleteRequest parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vaultName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter vaultName is required and cannot be null."));
        }
        if (resourceGuardProxyName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGuardProxyName is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.unlockDeleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, vaultName, resourceGuardProxyName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public UnlockDeleteResponseInner unlockDelete(String resourceGroupName, String vaultName, String resourceGuardProxyName, UnlockDeleteRequest parameters) {
        return (UnlockDeleteResponseInner)this.unlockDeleteWithResponse(resourceGroupName, vaultName, resourceGuardProxyName, parameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceGuardProxyBaseResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceGuardProxyBaseResourceList)res.getValue()).value(), ((ResourceGuardProxyBaseResourceList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ResourceGuardProxyBaseResourceInner> listNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ResourceGuardProxyBaseResourceList> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceGuardProxyBaseResourceList)res.getValue()).value(), ((ResourceGuardProxyBaseResourceList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ResourceGuardProxyBaseResourceInner> listNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ResourceGuardProxyBaseResourceList> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ResourceGuardProxyBaseResourceList)res.getValue()).value(), ((ResourceGuardProxyBaseResourceList)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DataProtectionClientDppResourceGuardProxies")
    public static interface DppResourceGuardProxiesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupResourceGuardProxies")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ResourceGuardProxyBaseResourceList>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="vaultName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupResourceGuardProxies")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ResourceGuardProxyBaseResourceList> listSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="vaultName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupResourceGuardProxies/{resourceGuardProxyName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ResourceGuardProxyBaseResourceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="vaultName") String var4, @PathParam(value="resourceGuardProxyName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupResourceGuardProxies/{resourceGuardProxyName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ResourceGuardProxyBaseResourceInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="vaultName") String var4, @PathParam(value="resourceGuardProxyName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupResourceGuardProxies/{resourceGuardProxyName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ResourceGuardProxyBaseResourceInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="vaultName") String var4, @PathParam(value="resourceGuardProxyName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ResourceGuardProxyBaseResourceInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupResourceGuardProxies/{resourceGuardProxyName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ResourceGuardProxyBaseResourceInner> createOrUpdateSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="vaultName") String var4, @PathParam(value="resourceGuardProxyName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ResourceGuardProxyBaseResourceInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupResourceGuardProxies/{resourceGuardProxyName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="vaultName") String var4, @PathParam(value="resourceGuardProxyName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupResourceGuardProxies/{resourceGuardProxyName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<Void> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="vaultName") String var4, @PathParam(value="resourceGuardProxyName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupResourceGuardProxies/{resourceGuardProxyName}/unlockDelete")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<UnlockDeleteResponseInner>> unlockDelete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="vaultName") String var4, @PathParam(value="resourceGuardProxyName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") UnlockDeleteRequest var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupResourceGuardProxies/{resourceGuardProxyName}/unlockDelete")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<UnlockDeleteResponseInner> unlockDeleteSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="vaultName") String var4, @PathParam(value="resourceGuardProxyName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") UnlockDeleteRequest var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ResourceGuardProxyBaseResourceList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ResourceGuardProxyBaseResourceList> listNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

