/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.fluent.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.OperationExtendedInfo;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class OperationResourceInner
implements JsonSerializable<OperationResourceInner> {
    private OffsetDateTime endTime;
    private ManagementError error;
    private String id;
    private String name;
    private OperationExtendedInfo properties;
    private OffsetDateTime startTime;
    private String status;

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public OperationResourceInner withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public ManagementError error() {
        return this.error;
    }

    public OperationResourceInner withError(ManagementError error) {
        this.error = error;
        return this;
    }

    public String id() {
        return this.id;
    }

    public OperationResourceInner withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public OperationResourceInner withName(String name) {
        this.name = name;
        return this;
    }

    public OperationExtendedInfo properties() {
        return this.properties;
    }

    public OperationResourceInner withProperties(OperationExtendedInfo properties) {
        this.properties = properties;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OperationResourceInner withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public String status() {
        return this.status;
    }

    public OperationResourceInner withStatus(String status) {
        this.status = status;
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("status", this.status);
        return jsonWriter.writeEndObject();
    }

    public static OperationResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (OperationResourceInner)jsonReader.readObject(reader -> {
            OperationResourceInner deserializedOperationResourceInner = new OperationResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endTime".equals(fieldName)) {
                    deserializedOperationResourceInner.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedOperationResourceInner.error = ManagementError.fromJson((JsonReader)reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedOperationResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedOperationResourceInner.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedOperationResourceInner.properties = OperationExtendedInfo.fromJson(reader);
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedOperationResourceInner.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedOperationResourceInner.status = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationResourceInner;
        });
    }
}

