/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.fluent.models.ProjectInner;
import java.io.IOException;
import java.util.List;

public final class ProjectList
implements JsonSerializable<ProjectList> {
    private List<ProjectInner> value;
    private String nextLink;

    public List<ProjectInner> value() {
        return this.value;
    }

    public ProjectList withValue(List<ProjectInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public ProjectList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ProjectList fromJson(JsonReader jsonReader) throws IOException {
        return (ProjectList)jsonReader.readObject(reader -> {
            ProjectList deserializedProjectList = new ProjectList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedProjectList.value = value = reader.readArray(reader1 -> ProjectInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedProjectList.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProjectList;
        });
    }
}

