/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MongoMigrationProgressDetails;
import java.io.IOException;

public final class MongoMigrationCollection
implements JsonSerializable<MongoMigrationCollection> {
    private String sourceDatabase;
    private String sourceCollection;
    private String targetDatabase;
    private String targetCollection;
    private MongoMigrationProgressDetails migrationProgressDetails;

    public String sourceDatabase() {
        return this.sourceDatabase;
    }

    public MongoMigrationCollection withSourceDatabase(String sourceDatabase) {
        this.sourceDatabase = sourceDatabase;
        return this;
    }

    public String sourceCollection() {
        return this.sourceCollection;
    }

    public MongoMigrationCollection withSourceCollection(String sourceCollection) {
        this.sourceCollection = sourceCollection;
        return this;
    }

    public String targetDatabase() {
        return this.targetDatabase;
    }

    public MongoMigrationCollection withTargetDatabase(String targetDatabase) {
        this.targetDatabase = targetDatabase;
        return this;
    }

    public String targetCollection() {
        return this.targetCollection;
    }

    public MongoMigrationCollection withTargetCollection(String targetCollection) {
        this.targetCollection = targetCollection;
        return this;
    }

    public MongoMigrationProgressDetails migrationProgressDetails() {
        return this.migrationProgressDetails;
    }

    public void validate() {
        if (this.migrationProgressDetails() != null) {
            this.migrationProgressDetails().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceDatabase", this.sourceDatabase);
        jsonWriter.writeStringField("sourceCollection", this.sourceCollection);
        jsonWriter.writeStringField("targetDatabase", this.targetDatabase);
        jsonWriter.writeStringField("targetCollection", this.targetCollection);
        return jsonWriter.writeEndObject();
    }

    public static MongoMigrationCollection fromJson(JsonReader jsonReader) throws IOException {
        return (MongoMigrationCollection)jsonReader.readObject(reader -> {
            MongoMigrationCollection deserializedMongoMigrationCollection = new MongoMigrationCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceDatabase".equals(fieldName)) {
                    deserializedMongoMigrationCollection.sourceDatabase = reader.getString();
                    continue;
                }
                if ("sourceCollection".equals(fieldName)) {
                    deserializedMongoMigrationCollection.sourceCollection = reader.getString();
                    continue;
                }
                if ("targetDatabase".equals(fieldName)) {
                    deserializedMongoMigrationCollection.targetDatabase = reader.getString();
                    continue;
                }
                if ("targetCollection".equals(fieldName)) {
                    deserializedMongoMigrationCollection.targetCollection = reader.getString();
                    continue;
                }
                if ("migrationProgressDetails".equals(fieldName)) {
                    deserializedMongoMigrationCollection.migrationProgressDetails = MongoMigrationProgressDetails.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoMigrationCollection;
        });
    }
}

