/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MigrateSsisTaskOutput;
import com.azure.resourcemanager.datamigration.models.MigrationStatus;
import com.azure.resourcemanager.datamigration.models.ReportableException;
import com.azure.resourcemanager.datamigration.models.SsisMigrationStage;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class MigrateSsisTaskOutputMigrationLevel
extends MigrateSsisTaskOutput {
    private String resultType = "MigrationLevelOutput";
    private OffsetDateTime startedOn;
    private OffsetDateTime endedOn;
    private MigrationStatus status;
    private String message;
    private String sourceServerVersion;
    private String sourceServerBrandVersion;
    private String targetServerVersion;
    private String targetServerBrandVersion;
    private List<ReportableException> exceptionsAndWarnings;
    private SsisMigrationStage stage;

    @Override
    public String resultType() {
        return this.resultType;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    public MigrationStatus status() {
        return this.status;
    }

    public String message() {
        return this.message;
    }

    public String sourceServerVersion() {
        return this.sourceServerVersion;
    }

    public String sourceServerBrandVersion() {
        return this.sourceServerBrandVersion;
    }

    public String targetServerVersion() {
        return this.targetServerVersion;
    }

    public String targetServerBrandVersion() {
        return this.targetServerBrandVersion;
    }

    public List<ReportableException> exceptionsAndWarnings() {
        return this.exceptionsAndWarnings;
    }

    public SsisMigrationStage stage() {
        return this.stage;
    }

    @Override
    public void validate() {
        if (this.exceptionsAndWarnings() != null) {
            this.exceptionsAndWarnings().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultType", this.resultType);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSsisTaskOutputMigrationLevel fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSsisTaskOutputMigrationLevel)jsonReader.readObject(reader -> {
            MigrateSsisTaskOutputMigrationLevel deserializedMigrateSsisTaskOutputMigrationLevel = new MigrateSsisTaskOutputMigrationLevel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMigrateSsisTaskOutputMigrationLevel.withId(reader.getString());
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedMigrateSsisTaskOutputMigrationLevel.resultType = reader.getString();
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedMigrateSsisTaskOutputMigrationLevel.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedMigrateSsisTaskOutputMigrationLevel.endedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedMigrateSsisTaskOutputMigrationLevel.status = MigrationStatus.fromString(reader.getString());
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedMigrateSsisTaskOutputMigrationLevel.message = reader.getString();
                    continue;
                }
                if ("sourceServerVersion".equals(fieldName)) {
                    deserializedMigrateSsisTaskOutputMigrationLevel.sourceServerVersion = reader.getString();
                    continue;
                }
                if ("sourceServerBrandVersion".equals(fieldName)) {
                    deserializedMigrateSsisTaskOutputMigrationLevel.sourceServerBrandVersion = reader.getString();
                    continue;
                }
                if ("targetServerVersion".equals(fieldName)) {
                    deserializedMigrateSsisTaskOutputMigrationLevel.targetServerVersion = reader.getString();
                    continue;
                }
                if ("targetServerBrandVersion".equals(fieldName)) {
                    deserializedMigrateSsisTaskOutputMigrationLevel.targetServerBrandVersion = reader.getString();
                    continue;
                }
                if ("exceptionsAndWarnings".equals(fieldName)) {
                    List exceptionsAndWarnings;
                    deserializedMigrateSsisTaskOutputMigrationLevel.exceptionsAndWarnings = exceptionsAndWarnings = reader.readArray(reader1 -> ReportableException.fromJson(reader1));
                    continue;
                }
                if ("stage".equals(fieldName)) {
                    deserializedMigrateSsisTaskOutputMigrationLevel.stage = SsisMigrationStage.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSsisTaskOutputMigrationLevel;
        });
    }
}

