/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MigrateMySqlAzureDbForMySqlOfflineDatabaseInput;
import com.azure.resourcemanager.datamigration.models.MySqlConnectionInfo;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

public final class MigrateMySqlAzureDbForMySqlOfflineTaskInput
implements JsonSerializable<MigrateMySqlAzureDbForMySqlOfflineTaskInput> {
    private MySqlConnectionInfo sourceConnectionInfo;
    private MySqlConnectionInfo targetConnectionInfo;
    private List<MigrateMySqlAzureDbForMySqlOfflineDatabaseInput> selectedDatabases;
    private Boolean makeSourceServerReadOnly;
    private OffsetDateTime startedOn;
    private Map<String, String> optionalAgentSettings;
    private String encryptedKeyForSecureFields;
    private static final ClientLogger LOGGER = new ClientLogger(MigrateMySqlAzureDbForMySqlOfflineTaskInput.class);

    public MySqlConnectionInfo sourceConnectionInfo() {
        return this.sourceConnectionInfo;
    }

    public MigrateMySqlAzureDbForMySqlOfflineTaskInput withSourceConnectionInfo(MySqlConnectionInfo sourceConnectionInfo) {
        this.sourceConnectionInfo = sourceConnectionInfo;
        return this;
    }

    public MySqlConnectionInfo targetConnectionInfo() {
        return this.targetConnectionInfo;
    }

    public MigrateMySqlAzureDbForMySqlOfflineTaskInput withTargetConnectionInfo(MySqlConnectionInfo targetConnectionInfo) {
        this.targetConnectionInfo = targetConnectionInfo;
        return this;
    }

    public List<MigrateMySqlAzureDbForMySqlOfflineDatabaseInput> selectedDatabases() {
        return this.selectedDatabases;
    }

    public MigrateMySqlAzureDbForMySqlOfflineTaskInput withSelectedDatabases(List<MigrateMySqlAzureDbForMySqlOfflineDatabaseInput> selectedDatabases) {
        this.selectedDatabases = selectedDatabases;
        return this;
    }

    public Boolean makeSourceServerReadOnly() {
        return this.makeSourceServerReadOnly;
    }

    public MigrateMySqlAzureDbForMySqlOfflineTaskInput withMakeSourceServerReadOnly(Boolean makeSourceServerReadOnly) {
        this.makeSourceServerReadOnly = makeSourceServerReadOnly;
        return this;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    public MigrateMySqlAzureDbForMySqlOfflineTaskInput withStartedOn(OffsetDateTime startedOn) {
        this.startedOn = startedOn;
        return this;
    }

    public Map<String, String> optionalAgentSettings() {
        return this.optionalAgentSettings;
    }

    public MigrateMySqlAzureDbForMySqlOfflineTaskInput withOptionalAgentSettings(Map<String, String> optionalAgentSettings) {
        this.optionalAgentSettings = optionalAgentSettings;
        return this;
    }

    public String encryptedKeyForSecureFields() {
        return this.encryptedKeyForSecureFields;
    }

    public MigrateMySqlAzureDbForMySqlOfflineTaskInput withEncryptedKeyForSecureFields(String encryptedKeyForSecureFields) {
        this.encryptedKeyForSecureFields = encryptedKeyForSecureFields;
        return this;
    }

    public void validate() {
        if (this.sourceConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceConnectionInfo in model MigrateMySqlAzureDbForMySqlOfflineTaskInput"));
        }
        this.sourceConnectionInfo().validate();
        if (this.targetConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetConnectionInfo in model MigrateMySqlAzureDbForMySqlOfflineTaskInput"));
        }
        this.targetConnectionInfo().validate();
        if (this.selectedDatabases() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property selectedDatabases in model MigrateMySqlAzureDbForMySqlOfflineTaskInput"));
        }
        this.selectedDatabases().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceConnectionInfo", (JsonSerializable)this.sourceConnectionInfo);
        jsonWriter.writeJsonField("targetConnectionInfo", (JsonSerializable)this.targetConnectionInfo);
        jsonWriter.writeArrayField("selectedDatabases", this.selectedDatabases, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("makeSourceServerReadOnly", this.makeSourceServerReadOnly);
        jsonWriter.writeStringField("startedOn", this.startedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startedOn));
        jsonWriter.writeMapField("optionalAgentSettings", this.optionalAgentSettings, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("encryptedKeyForSecureFields", this.encryptedKeyForSecureFields);
        return jsonWriter.writeEndObject();
    }

    public static MigrateMySqlAzureDbForMySqlOfflineTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateMySqlAzureDbForMySqlOfflineTaskInput)jsonReader.readObject(reader -> {
            MigrateMySqlAzureDbForMySqlOfflineTaskInput deserializedMigrateMySqlAzureDbForMySqlOfflineTaskInput = new MigrateMySqlAzureDbForMySqlOfflineTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceConnectionInfo".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskInput.sourceConnectionInfo = MySqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("targetConnectionInfo".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskInput.targetConnectionInfo = MySqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("selectedDatabases".equals(fieldName)) {
                    List selectedDatabases;
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskInput.selectedDatabases = selectedDatabases = reader.readArray(reader1 -> MigrateMySqlAzureDbForMySqlOfflineDatabaseInput.fromJson(reader1));
                    continue;
                }
                if ("makeSourceServerReadOnly".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskInput.makeSourceServerReadOnly = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskInput.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("optionalAgentSettings".equals(fieldName)) {
                    Map optionalAgentSettings;
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskInput.optionalAgentSettings = optionalAgentSettings = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("encryptedKeyForSecureFields".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskInput.encryptedKeyForSecureFields = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateMySqlAzureDbForMySqlOfflineTaskInput;
        });
    }
}

