/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MySqlConnectionInfo;
import java.io.IOException;
import java.util.List;

public final class GetUserTablesMySqlTaskInput
implements JsonSerializable<GetUserTablesMySqlTaskInput> {
    private MySqlConnectionInfo connectionInfo;
    private List<String> selectedDatabases;
    private static final ClientLogger LOGGER = new ClientLogger(GetUserTablesMySqlTaskInput.class);

    public MySqlConnectionInfo connectionInfo() {
        return this.connectionInfo;
    }

    public GetUserTablesMySqlTaskInput withConnectionInfo(MySqlConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
        return this;
    }

    public List<String> selectedDatabases() {
        return this.selectedDatabases;
    }

    public GetUserTablesMySqlTaskInput withSelectedDatabases(List<String> selectedDatabases) {
        this.selectedDatabases = selectedDatabases;
        return this;
    }

    public void validate() {
        if (this.connectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property connectionInfo in model GetUserTablesMySqlTaskInput"));
        }
        this.connectionInfo().validate();
        if (this.selectedDatabases() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property selectedDatabases in model GetUserTablesMySqlTaskInput"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("connectionInfo", (JsonSerializable)this.connectionInfo);
        jsonWriter.writeArrayField("selectedDatabases", this.selectedDatabases, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static GetUserTablesMySqlTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (GetUserTablesMySqlTaskInput)jsonReader.readObject(reader -> {
            GetUserTablesMySqlTaskInput deserializedGetUserTablesMySqlTaskInput = new GetUserTablesMySqlTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionInfo".equals(fieldName)) {
                    deserializedGetUserTablesMySqlTaskInput.connectionInfo = MySqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("selectedDatabases".equals(fieldName)) {
                    List selectedDatabases;
                    deserializedGetUserTablesMySqlTaskInput.selectedDatabases = selectedDatabases = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGetUserTablesMySqlTaskInput;
        });
    }
}

