/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.SourceLocation;
import com.azure.resourcemanager.datamigration.models.TargetLocation;
import java.io.IOException;

public final class BackupConfiguration
implements JsonSerializable<BackupConfiguration> {
    private SourceLocation sourceLocation;
    private TargetLocation targetLocation;

    public SourceLocation sourceLocation() {
        return this.sourceLocation;
    }

    public BackupConfiguration withSourceLocation(SourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
        return this;
    }

    public TargetLocation targetLocation() {
        return this.targetLocation;
    }

    public BackupConfiguration withTargetLocation(TargetLocation targetLocation) {
        this.targetLocation = targetLocation;
        return this;
    }

    public void validate() {
        if (this.sourceLocation() != null) {
            this.sourceLocation().validate();
        }
        if (this.targetLocation() != null) {
            this.targetLocation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceLocation", (JsonSerializable)this.sourceLocation);
        jsonWriter.writeJsonField("targetLocation", (JsonSerializable)this.targetLocation);
        return jsonWriter.writeEndObject();
    }

    public static BackupConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (BackupConfiguration)jsonReader.readObject(reader -> {
            BackupConfiguration deserializedBackupConfiguration = new BackupConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceLocation".equals(fieldName)) {
                    deserializedBackupConfiguration.sourceLocation = SourceLocation.fromJson(reader);
                    continue;
                }
                if ("targetLocation".equals(fieldName)) {
                    deserializedBackupConfiguration.targetLocation = TargetLocation.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupConfiguration;
        });
    }
}

