/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.datamigration.fluent.DatabaseMigrationsSqlDbsClient;
import com.azure.resourcemanager.datamigration.fluent.models.DatabaseMigrationSqlDbInner;
import com.azure.resourcemanager.datamigration.implementation.DataMigrationManagementClientImpl;
import com.azure.resourcemanager.datamigration.models.MigrationOperationInput;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.UUID;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DatabaseMigrationsSqlDbsClientImpl
implements DatabaseMigrationsSqlDbsClient {
    private final DatabaseMigrationsSqlDbsService service;
    private final DataMigrationManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(DatabaseMigrationsSqlDbsClientImpl.class);

    DatabaseMigrationsSqlDbsClientImpl(DataMigrationManagementClientImpl client) {
        this.service = (DatabaseMigrationsSqlDbsService)RestProxy.create(DatabaseMigrationsSqlDbsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DatabaseMigrationSqlDbInner>> getWithResponseAsync(String resourceGroupName, String sqlDbInstanceName, String targetDbName, UUID migrationOperationId, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlDbInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sqlDbInstanceName is required and cannot be null."));
        }
        if (targetDbName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, sqlDbInstanceName, targetDbName, migrationOperationId, expand, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DatabaseMigrationSqlDbInner> getAsync(String resourceGroupName, String sqlDbInstanceName, String targetDbName) {
        UUID migrationOperationId = null;
        String expand = null;
        return this.getWithResponseAsync(resourceGroupName, sqlDbInstanceName, targetDbName, migrationOperationId, expand).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DatabaseMigrationSqlDbInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DatabaseMigrationSqlDbInner> getWithResponse(String resourceGroupName, String sqlDbInstanceName, String targetDbName, UUID migrationOperationId, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlDbInstanceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlDbInstanceName is required and cannot be null."));
        }
        if (targetDbName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), resourceGroupName, sqlDbInstanceName, targetDbName, migrationOperationId, expand, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseMigrationSqlDbInner get(String resourceGroupName, String sqlDbInstanceName, String targetDbName) {
        UUID migrationOperationId = null;
        String expand = null;
        return (DatabaseMigrationSqlDbInner)((Object)this.getWithResponse(resourceGroupName, sqlDbInstanceName, targetDbName, migrationOperationId, expand, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String sqlDbInstanceName, String targetDbName, DatabaseMigrationSqlDbInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlDbInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sqlDbInstanceName is required and cannot be null."));
        }
        if (targetDbName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, sqlDbInstanceName, targetDbName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String sqlDbInstanceName, String targetDbName, DatabaseMigrationSqlDbInner parameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlDbInstanceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlDbInstanceName is required and cannot be null."));
        }
        if (targetDbName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), resourceGroupName, sqlDbInstanceName, targetDbName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String sqlDbInstanceName, String targetDbName, DatabaseMigrationSqlDbInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlDbInstanceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlDbInstanceName is required and cannot be null."));
        }
        if (targetDbName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), resourceGroupName, sqlDbInstanceName, targetDbName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DatabaseMigrationSqlDbInner>, DatabaseMigrationSqlDbInner> beginCreateOrUpdateAsync(String resourceGroupName, String sqlDbInstanceName, String targetDbName, DatabaseMigrationSqlDbInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, sqlDbInstanceName, targetDbName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DatabaseMigrationSqlDbInner.class), (Type)((Object)DatabaseMigrationSqlDbInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DatabaseMigrationSqlDbInner>, DatabaseMigrationSqlDbInner> beginCreateOrUpdate(String resourceGroupName, String sqlDbInstanceName, String targetDbName, DatabaseMigrationSqlDbInner parameters) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, sqlDbInstanceName, targetDbName, parameters);
        return this.client.getLroResult(response, (Type)((Object)DatabaseMigrationSqlDbInner.class), (Type)((Object)DatabaseMigrationSqlDbInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DatabaseMigrationSqlDbInner>, DatabaseMigrationSqlDbInner> beginCreateOrUpdate(String resourceGroupName, String sqlDbInstanceName, String targetDbName, DatabaseMigrationSqlDbInner parameters, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, sqlDbInstanceName, targetDbName, parameters, context);
        return this.client.getLroResult(response, (Type)((Object)DatabaseMigrationSqlDbInner.class), (Type)((Object)DatabaseMigrationSqlDbInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DatabaseMigrationSqlDbInner> createOrUpdateAsync(String resourceGroupName, String sqlDbInstanceName, String targetDbName, DatabaseMigrationSqlDbInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, sqlDbInstanceName, targetDbName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseMigrationSqlDbInner createOrUpdate(String resourceGroupName, String sqlDbInstanceName, String targetDbName, DatabaseMigrationSqlDbInner parameters) {
        return (DatabaseMigrationSqlDbInner)((Object)this.beginCreateOrUpdate(resourceGroupName, sqlDbInstanceName, targetDbName, parameters).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseMigrationSqlDbInner createOrUpdate(String resourceGroupName, String sqlDbInstanceName, String targetDbName, DatabaseMigrationSqlDbInner parameters, Context context) {
        return (DatabaseMigrationSqlDbInner)((Object)this.beginCreateOrUpdate(resourceGroupName, sqlDbInstanceName, targetDbName, parameters, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String sqlDbInstanceName, String targetDbName, Boolean force) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlDbInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sqlDbInstanceName is required and cannot be null."));
        }
        if (targetDbName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, sqlDbInstanceName, targetDbName, force, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String sqlDbInstanceName, String targetDbName, Boolean force) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlDbInstanceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlDbInstanceName is required and cannot be null."));
        }
        if (targetDbName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return this.service.deleteSync(this.client.getEndpoint(), resourceGroupName, sqlDbInstanceName, targetDbName, force, this.client.getSubscriptionId(), this.client.getApiVersion(), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String sqlDbInstanceName, String targetDbName, Boolean force, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlDbInstanceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlDbInstanceName is required and cannot be null."));
        }
        if (targetDbName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return this.service.deleteSync(this.client.getEndpoint(), resourceGroupName, sqlDbInstanceName, targetDbName, force, this.client.getSubscriptionId(), this.client.getApiVersion(), context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String sqlDbInstanceName, String targetDbName, Boolean force) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, sqlDbInstanceName, targetDbName, force);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String sqlDbInstanceName, String targetDbName) {
        Boolean force = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, sqlDbInstanceName, targetDbName, force);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String sqlDbInstanceName, String targetDbName, Boolean force) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, sqlDbInstanceName, targetDbName, force);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String sqlDbInstanceName, String targetDbName) {
        Boolean force = null;
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, sqlDbInstanceName, targetDbName, force);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String sqlDbInstanceName, String targetDbName, Boolean force, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, sqlDbInstanceName, targetDbName, force, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String sqlDbInstanceName, String targetDbName, Boolean force) {
        return this.beginDeleteAsync(resourceGroupName, sqlDbInstanceName, targetDbName, force).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String sqlDbInstanceName, String targetDbName) {
        Boolean force = null;
        return this.beginDeleteAsync(resourceGroupName, sqlDbInstanceName, targetDbName, force).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String sqlDbInstanceName, String targetDbName) {
        Boolean force = null;
        this.beginDelete(resourceGroupName, sqlDbInstanceName, targetDbName, force).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String sqlDbInstanceName, String targetDbName, Boolean force, Context context) {
        this.beginDelete(resourceGroupName, sqlDbInstanceName, targetDbName, force, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> cancelWithResponseAsync(String resourceGroupName, String sqlDbInstanceName, String targetDbName, MigrationOperationInput parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlDbInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sqlDbInstanceName is required and cannot be null."));
        }
        if (targetDbName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return FluxUtil.withContext(context -> this.service.cancel(this.client.getEndpoint(), resourceGroupName, sqlDbInstanceName, targetDbName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> cancelWithResponse(String resourceGroupName, String sqlDbInstanceName, String targetDbName, MigrationOperationInput parameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlDbInstanceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlDbInstanceName is required and cannot be null."));
        }
        if (targetDbName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return this.service.cancelSync(this.client.getEndpoint(), resourceGroupName, sqlDbInstanceName, targetDbName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> cancelWithResponse(String resourceGroupName, String sqlDbInstanceName, String targetDbName, MigrationOperationInput parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlDbInstanceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlDbInstanceName is required and cannot be null."));
        }
        if (targetDbName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return this.service.cancelSync(this.client.getEndpoint(), resourceGroupName, sqlDbInstanceName, targetDbName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginCancelAsync(String resourceGroupName, String sqlDbInstanceName, String targetDbName, MigrationOperationInput parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.cancelWithResponseAsync(resourceGroupName, sqlDbInstanceName, targetDbName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginCancel(String resourceGroupName, String sqlDbInstanceName, String targetDbName, MigrationOperationInput parameters) {
        Response<BinaryData> response = this.cancelWithResponse(resourceGroupName, sqlDbInstanceName, targetDbName, parameters);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginCancel(String resourceGroupName, String sqlDbInstanceName, String targetDbName, MigrationOperationInput parameters, Context context) {
        Response<BinaryData> response = this.cancelWithResponse(resourceGroupName, sqlDbInstanceName, targetDbName, parameters, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> cancelAsync(String resourceGroupName, String sqlDbInstanceName, String targetDbName, MigrationOperationInput parameters) {
        return this.beginCancelAsync(resourceGroupName, sqlDbInstanceName, targetDbName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancel(String resourceGroupName, String sqlDbInstanceName, String targetDbName, MigrationOperationInput parameters) {
        this.beginCancel(resourceGroupName, sqlDbInstanceName, targetDbName, parameters).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancel(String resourceGroupName, String sqlDbInstanceName, String targetDbName, MigrationOperationInput parameters, Context context) {
        this.beginCancel(resourceGroupName, sqlDbInstanceName, targetDbName, parameters, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> retryWithResponseAsync(String resourceGroupName, String sqlDbInstanceName, String targetDbName, MigrationOperationInput migrationOperationInput) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlDbInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sqlDbInstanceName is required and cannot be null."));
        }
        if (targetDbName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (migrationOperationInput == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter migrationOperationInput is required and cannot be null."));
        }
        migrationOperationInput.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.retry(this.client.getEndpoint(), resourceGroupName, sqlDbInstanceName, targetDbName, this.client.getSubscriptionId(), this.client.getApiVersion(), migrationOperationInput, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> retryWithResponse(String resourceGroupName, String sqlDbInstanceName, String targetDbName, MigrationOperationInput migrationOperationInput) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlDbInstanceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlDbInstanceName is required and cannot be null."));
        }
        if (targetDbName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (migrationOperationInput == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter migrationOperationInput is required and cannot be null."));
        }
        migrationOperationInput.validate();
        String accept = "application/json";
        return this.service.retrySync(this.client.getEndpoint(), resourceGroupName, sqlDbInstanceName, targetDbName, this.client.getSubscriptionId(), this.client.getApiVersion(), migrationOperationInput, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> retryWithResponse(String resourceGroupName, String sqlDbInstanceName, String targetDbName, MigrationOperationInput migrationOperationInput, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlDbInstanceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlDbInstanceName is required and cannot be null."));
        }
        if (targetDbName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (migrationOperationInput == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter migrationOperationInput is required and cannot be null."));
        }
        migrationOperationInput.validate();
        String accept = "application/json";
        return this.service.retrySync(this.client.getEndpoint(), resourceGroupName, sqlDbInstanceName, targetDbName, this.client.getSubscriptionId(), this.client.getApiVersion(), migrationOperationInput, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DatabaseMigrationSqlDbInner>, DatabaseMigrationSqlDbInner> beginRetryAsync(String resourceGroupName, String sqlDbInstanceName, String targetDbName, MigrationOperationInput migrationOperationInput) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.retryWithResponseAsync(resourceGroupName, sqlDbInstanceName, targetDbName, migrationOperationInput);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DatabaseMigrationSqlDbInner.class), (Type)((Object)DatabaseMigrationSqlDbInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DatabaseMigrationSqlDbInner>, DatabaseMigrationSqlDbInner> beginRetry(String resourceGroupName, String sqlDbInstanceName, String targetDbName, MigrationOperationInput migrationOperationInput) {
        Response<BinaryData> response = this.retryWithResponse(resourceGroupName, sqlDbInstanceName, targetDbName, migrationOperationInput);
        return this.client.getLroResult(response, (Type)((Object)DatabaseMigrationSqlDbInner.class), (Type)((Object)DatabaseMigrationSqlDbInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DatabaseMigrationSqlDbInner>, DatabaseMigrationSqlDbInner> beginRetry(String resourceGroupName, String sqlDbInstanceName, String targetDbName, MigrationOperationInput migrationOperationInput, Context context) {
        Response<BinaryData> response = this.retryWithResponse(resourceGroupName, sqlDbInstanceName, targetDbName, migrationOperationInput, context);
        return this.client.getLroResult(response, (Type)((Object)DatabaseMigrationSqlDbInner.class), (Type)((Object)DatabaseMigrationSqlDbInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DatabaseMigrationSqlDbInner> retryAsync(String resourceGroupName, String sqlDbInstanceName, String targetDbName, MigrationOperationInput migrationOperationInput) {
        return this.beginRetryAsync(resourceGroupName, sqlDbInstanceName, targetDbName, migrationOperationInput).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseMigrationSqlDbInner retry(String resourceGroupName, String sqlDbInstanceName, String targetDbName, MigrationOperationInput migrationOperationInput) {
        return (DatabaseMigrationSqlDbInner)((Object)this.beginRetry(resourceGroupName, sqlDbInstanceName, targetDbName, migrationOperationInput).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseMigrationSqlDbInner retry(String resourceGroupName, String sqlDbInstanceName, String targetDbName, MigrationOperationInput migrationOperationInput, Context context) {
        return (DatabaseMigrationSqlDbInner)((Object)this.beginRetry(resourceGroupName, sqlDbInstanceName, targetDbName, migrationOperationInput, context).getFinalResult());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DataMigrationManagementClientDatabaseMigrationsSqlDbs")
    public static interface DatabaseMigrationsSqlDbsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{sqlDbInstanceName}/providers/Microsoft.DataMigration/databaseMigrations/{targetDbName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseMigrationSqlDbInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlDbInstanceName") String var3, @PathParam(value="targetDbName") String var4, @QueryParam(value="migrationOperationId") UUID var5, @QueryParam(value="$expand") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{sqlDbInstanceName}/providers/Microsoft.DataMigration/databaseMigrations/{targetDbName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DatabaseMigrationSqlDbInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlDbInstanceName") String var3, @PathParam(value="targetDbName") String var4, @QueryParam(value="migrationOperationId") UUID var5, @QueryParam(value="$expand") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{sqlDbInstanceName}/providers/Microsoft.DataMigration/databaseMigrations/{targetDbName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlDbInstanceName") String var3, @PathParam(value="targetDbName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") DatabaseMigrationSqlDbInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{sqlDbInstanceName}/providers/Microsoft.DataMigration/databaseMigrations/{targetDbName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlDbInstanceName") String var3, @PathParam(value="targetDbName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") DatabaseMigrationSqlDbInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{sqlDbInstanceName}/providers/Microsoft.DataMigration/databaseMigrations/{targetDbName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlDbInstanceName") String var3, @PathParam(value="targetDbName") String var4, @QueryParam(value="force") Boolean var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{sqlDbInstanceName}/providers/Microsoft.DataMigration/databaseMigrations/{targetDbName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlDbInstanceName") String var3, @PathParam(value="targetDbName") String var4, @QueryParam(value="force") Boolean var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{sqlDbInstanceName}/providers/Microsoft.DataMigration/databaseMigrations/{targetDbName}/cancel")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> cancel(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlDbInstanceName") String var3, @PathParam(value="targetDbName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") MigrationOperationInput var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{sqlDbInstanceName}/providers/Microsoft.DataMigration/databaseMigrations/{targetDbName}/cancel")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> cancelSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlDbInstanceName") String var3, @PathParam(value="targetDbName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") MigrationOperationInput var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{sqlDbInstanceName}/providers/Microsoft.DataMigration/databaseMigrations/{targetDbName}/retry")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> retry(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlDbInstanceName") String var3, @PathParam(value="targetDbName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") MigrationOperationInput var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{sqlDbInstanceName}/providers/Microsoft.DataMigration/databaseMigrations/{targetDbName}/retry")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> retrySync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlDbInstanceName") String var3, @PathParam(value="targetDbName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") MigrationOperationInput var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

