/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.datamigration.fluent.DatabaseMigrationsMongoToCosmosDbvCoreMongoesClient;
import com.azure.resourcemanager.datamigration.fluent.models.DatabaseMigrationCosmosDbMongoInner;
import com.azure.resourcemanager.datamigration.implementation.DataMigrationManagementClientImpl;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationCosmosDbMongoListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DatabaseMigrationsMongoToCosmosDbvCoreMongoesClientImpl
implements DatabaseMigrationsMongoToCosmosDbvCoreMongoesClient {
    private final DatabaseMigrationsMongoToCosmosDbvCoreMongoesService service;
    private final DataMigrationManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(DatabaseMigrationsMongoToCosmosDbvCoreMongoesClientImpl.class);

    DatabaseMigrationsMongoToCosmosDbvCoreMongoesClientImpl(DataMigrationManagementClientImpl client) {
        this.service = (DatabaseMigrationsMongoToCosmosDbvCoreMongoesService)RestProxy.create(DatabaseMigrationsMongoToCosmosDbvCoreMongoesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DatabaseMigrationCosmosDbMongoInner>> getWithResponseAsync(String resourceGroupName, String targetResourceName, String migrationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetResourceName is required and cannot be null."));
        }
        if (migrationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter migrationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, targetResourceName, migrationName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DatabaseMigrationCosmosDbMongoInner> getAsync(String resourceGroupName, String targetResourceName, String migrationName) {
        return this.getWithResponseAsync(resourceGroupName, targetResourceName, migrationName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DatabaseMigrationCosmosDbMongoInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DatabaseMigrationCosmosDbMongoInner> getWithResponse(String resourceGroupName, String targetResourceName, String migrationName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetResourceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetResourceName is required and cannot be null."));
        }
        if (migrationName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter migrationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), resourceGroupName, targetResourceName, migrationName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseMigrationCosmosDbMongoInner get(String resourceGroupName, String targetResourceName, String migrationName) {
        return (DatabaseMigrationCosmosDbMongoInner)((Object)this.getWithResponse(resourceGroupName, targetResourceName, migrationName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String targetResourceName, String migrationName, DatabaseMigrationCosmosDbMongoInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetResourceName is required and cannot be null."));
        }
        if (migrationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter migrationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), resourceGroupName, targetResourceName, migrationName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createWithResponse(String resourceGroupName, String targetResourceName, String migrationName, DatabaseMigrationCosmosDbMongoInner parameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetResourceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetResourceName is required and cannot be null."));
        }
        if (migrationName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter migrationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.createSync(this.client.getEndpoint(), resourceGroupName, targetResourceName, migrationName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createWithResponse(String resourceGroupName, String targetResourceName, String migrationName, DatabaseMigrationCosmosDbMongoInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetResourceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetResourceName is required and cannot be null."));
        }
        if (migrationName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter migrationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.createSync(this.client.getEndpoint(), resourceGroupName, targetResourceName, migrationName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DatabaseMigrationCosmosDbMongoInner>, DatabaseMigrationCosmosDbMongoInner> beginCreateAsync(String resourceGroupName, String targetResourceName, String migrationName, DatabaseMigrationCosmosDbMongoInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, targetResourceName, migrationName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DatabaseMigrationCosmosDbMongoInner.class), (Type)((Object)DatabaseMigrationCosmosDbMongoInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DatabaseMigrationCosmosDbMongoInner>, DatabaseMigrationCosmosDbMongoInner> beginCreate(String resourceGroupName, String targetResourceName, String migrationName, DatabaseMigrationCosmosDbMongoInner parameters) {
        Response<BinaryData> response = this.createWithResponse(resourceGroupName, targetResourceName, migrationName, parameters);
        return this.client.getLroResult(response, (Type)((Object)DatabaseMigrationCosmosDbMongoInner.class), (Type)((Object)DatabaseMigrationCosmosDbMongoInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DatabaseMigrationCosmosDbMongoInner>, DatabaseMigrationCosmosDbMongoInner> beginCreate(String resourceGroupName, String targetResourceName, String migrationName, DatabaseMigrationCosmosDbMongoInner parameters, Context context) {
        Response<BinaryData> response = this.createWithResponse(resourceGroupName, targetResourceName, migrationName, parameters, context);
        return this.client.getLroResult(response, (Type)((Object)DatabaseMigrationCosmosDbMongoInner.class), (Type)((Object)DatabaseMigrationCosmosDbMongoInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DatabaseMigrationCosmosDbMongoInner> createAsync(String resourceGroupName, String targetResourceName, String migrationName, DatabaseMigrationCosmosDbMongoInner parameters) {
        return this.beginCreateAsync(resourceGroupName, targetResourceName, migrationName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseMigrationCosmosDbMongoInner create(String resourceGroupName, String targetResourceName, String migrationName, DatabaseMigrationCosmosDbMongoInner parameters) {
        return (DatabaseMigrationCosmosDbMongoInner)((Object)this.beginCreate(resourceGroupName, targetResourceName, migrationName, parameters).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseMigrationCosmosDbMongoInner create(String resourceGroupName, String targetResourceName, String migrationName, DatabaseMigrationCosmosDbMongoInner parameters, Context context) {
        return (DatabaseMigrationCosmosDbMongoInner)((Object)this.beginCreate(resourceGroupName, targetResourceName, migrationName, parameters, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String targetResourceName, String migrationName, Boolean force) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetResourceName is required and cannot be null."));
        }
        if (migrationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter migrationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, targetResourceName, migrationName, force, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String targetResourceName, String migrationName, Boolean force) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetResourceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetResourceName is required and cannot be null."));
        }
        if (migrationName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter migrationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), resourceGroupName, targetResourceName, migrationName, force, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String targetResourceName, String migrationName, Boolean force, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetResourceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetResourceName is required and cannot be null."));
        }
        if (migrationName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter migrationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), resourceGroupName, targetResourceName, migrationName, force, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String targetResourceName, String migrationName, Boolean force) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, targetResourceName, migrationName, force);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String targetResourceName, String migrationName) {
        Boolean force = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, targetResourceName, migrationName, force);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String targetResourceName, String migrationName, Boolean force) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, targetResourceName, migrationName, force);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String targetResourceName, String migrationName) {
        Boolean force = null;
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, targetResourceName, migrationName, force);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String targetResourceName, String migrationName, Boolean force, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, targetResourceName, migrationName, force, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String targetResourceName, String migrationName, Boolean force) {
        return this.beginDeleteAsync(resourceGroupName, targetResourceName, migrationName, force).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String targetResourceName, String migrationName) {
        Boolean force = null;
        return this.beginDeleteAsync(resourceGroupName, targetResourceName, migrationName, force).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String targetResourceName, String migrationName) {
        Boolean force = null;
        this.beginDelete(resourceGroupName, targetResourceName, migrationName, force).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String targetResourceName, String migrationName, Boolean force, Context context) {
        this.beginDelete(resourceGroupName, targetResourceName, migrationName, force, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseMigrationCosmosDbMongoInner>> getForScopeSinglePageAsync(String resourceGroupName, String targetResourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetResourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getForScope(this.client.getEndpoint(), resourceGroupName, targetResourceName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseMigrationCosmosDbMongoListResult)res.getValue()).value(), ((DatabaseMigrationCosmosDbMongoListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DatabaseMigrationCosmosDbMongoInner> getForScopeAsync(String resourceGroupName, String targetResourceName) {
        return new PagedFlux(() -> this.getForScopeSinglePageAsync(resourceGroupName, targetResourceName), nextLink -> this.getForScopeNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DatabaseMigrationCosmosDbMongoInner> getForScopeSinglePage(String resourceGroupName, String targetResourceName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetResourceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetResourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<DatabaseMigrationCosmosDbMongoListResult> res = this.service.getForScopeSync(this.client.getEndpoint(), resourceGroupName, targetResourceName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseMigrationCosmosDbMongoListResult)res.getValue()).value(), ((DatabaseMigrationCosmosDbMongoListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DatabaseMigrationCosmosDbMongoInner> getForScopeSinglePage(String resourceGroupName, String targetResourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetResourceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetResourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<DatabaseMigrationCosmosDbMongoListResult> res = this.service.getForScopeSync(this.client.getEndpoint(), resourceGroupName, targetResourceName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseMigrationCosmosDbMongoListResult)res.getValue()).value(), ((DatabaseMigrationCosmosDbMongoListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DatabaseMigrationCosmosDbMongoInner> getForScope(String resourceGroupName, String targetResourceName) {
        return new PagedIterable(() -> this.getForScopeSinglePage(resourceGroupName, targetResourceName), nextLink -> this.getForScopeNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DatabaseMigrationCosmosDbMongoInner> getForScope(String resourceGroupName, String targetResourceName, Context context) {
        return new PagedIterable(() -> this.getForScopeSinglePage(resourceGroupName, targetResourceName, context), nextLink -> this.getForScopeNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseMigrationCosmosDbMongoInner>> getForScopeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getForScopeNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseMigrationCosmosDbMongoListResult)res.getValue()).value(), ((DatabaseMigrationCosmosDbMongoListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DatabaseMigrationCosmosDbMongoInner> getForScopeNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<DatabaseMigrationCosmosDbMongoListResult> res = this.service.getForScopeNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseMigrationCosmosDbMongoListResult)res.getValue()).value(), ((DatabaseMigrationCosmosDbMongoListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DatabaseMigrationCosmosDbMongoInner> getForScopeNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<DatabaseMigrationCosmosDbMongoListResult> res = this.service.getForScopeNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseMigrationCosmosDbMongoListResult)res.getValue()).value(), ((DatabaseMigrationCosmosDbMongoListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DataMigrationManagementClientDatabaseMigrationsMongoToCosmosDbvCoreMongoes")
    public static interface DatabaseMigrationsMongoToCosmosDbvCoreMongoesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/mongoClusters/{targetResourceName}/providers/Microsoft.DataMigration/databaseMigrations/{migrationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseMigrationCosmosDbMongoInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="targetResourceName") String var3, @PathParam(value="migrationName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/mongoClusters/{targetResourceName}/providers/Microsoft.DataMigration/databaseMigrations/{migrationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DatabaseMigrationCosmosDbMongoInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="targetResourceName") String var3, @PathParam(value="migrationName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/mongoClusters/{targetResourceName}/providers/Microsoft.DataMigration/databaseMigrations/{migrationName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="targetResourceName") String var3, @PathParam(value="migrationName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") DatabaseMigrationCosmosDbMongoInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/mongoClusters/{targetResourceName}/providers/Microsoft.DataMigration/databaseMigrations/{migrationName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="targetResourceName") String var3, @PathParam(value="migrationName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") DatabaseMigrationCosmosDbMongoInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/mongoClusters/{targetResourceName}/providers/Microsoft.DataMigration/databaseMigrations/{migrationName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="targetResourceName") String var3, @PathParam(value="migrationName") String var4, @QueryParam(value="force") Boolean var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/mongoClusters/{targetResourceName}/providers/Microsoft.DataMigration/databaseMigrations/{migrationName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="targetResourceName") String var3, @PathParam(value="migrationName") String var4, @QueryParam(value="force") Boolean var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/mongoClusters/{targetResourceName}/providers/Microsoft.DataMigration/databaseMigrations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseMigrationCosmosDbMongoListResult>> getForScope(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="targetResourceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/mongoClusters/{targetResourceName}/providers/Microsoft.DataMigration/databaseMigrations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DatabaseMigrationCosmosDbMongoListResult> getForScopeSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="targetResourceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseMigrationCosmosDbMongoListResult>> getForScopeNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DatabaseMigrationCosmosDbMongoListResult> getForScopeNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

