/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.BackupMode;
import com.azure.resourcemanager.datamigration.models.BlobShare;
import com.azure.resourcemanager.datamigration.models.FileShare;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlMIDatabaseInput;
import com.azure.resourcemanager.datamigration.models.SqlConnectionInfo;
import java.io.IOException;
import java.util.List;

public final class ValidateMigrationInputSqlServerSqlMITaskInput
implements JsonSerializable<ValidateMigrationInputSqlServerSqlMITaskInput> {
    private SqlConnectionInfo sourceConnectionInfo;
    private SqlConnectionInfo targetConnectionInfo;
    private List<MigrateSqlServerSqlMIDatabaseInput> selectedDatabases;
    private List<String> selectedLogins;
    private FileShare backupFileShare;
    private BlobShare backupBlobShare;
    private BackupMode backupMode;
    private static final ClientLogger LOGGER = new ClientLogger(ValidateMigrationInputSqlServerSqlMITaskInput.class);

    public SqlConnectionInfo sourceConnectionInfo() {
        return this.sourceConnectionInfo;
    }

    public ValidateMigrationInputSqlServerSqlMITaskInput withSourceConnectionInfo(SqlConnectionInfo sourceConnectionInfo) {
        this.sourceConnectionInfo = sourceConnectionInfo;
        return this;
    }

    public SqlConnectionInfo targetConnectionInfo() {
        return this.targetConnectionInfo;
    }

    public ValidateMigrationInputSqlServerSqlMITaskInput withTargetConnectionInfo(SqlConnectionInfo targetConnectionInfo) {
        this.targetConnectionInfo = targetConnectionInfo;
        return this;
    }

    public List<MigrateSqlServerSqlMIDatabaseInput> selectedDatabases() {
        return this.selectedDatabases;
    }

    public ValidateMigrationInputSqlServerSqlMITaskInput withSelectedDatabases(List<MigrateSqlServerSqlMIDatabaseInput> selectedDatabases) {
        this.selectedDatabases = selectedDatabases;
        return this;
    }

    public List<String> selectedLogins() {
        return this.selectedLogins;
    }

    public ValidateMigrationInputSqlServerSqlMITaskInput withSelectedLogins(List<String> selectedLogins) {
        this.selectedLogins = selectedLogins;
        return this;
    }

    public FileShare backupFileShare() {
        return this.backupFileShare;
    }

    public ValidateMigrationInputSqlServerSqlMITaskInput withBackupFileShare(FileShare backupFileShare) {
        this.backupFileShare = backupFileShare;
        return this;
    }

    public BlobShare backupBlobShare() {
        return this.backupBlobShare;
    }

    public ValidateMigrationInputSqlServerSqlMITaskInput withBackupBlobShare(BlobShare backupBlobShare) {
        this.backupBlobShare = backupBlobShare;
        return this;
    }

    public BackupMode backupMode() {
        return this.backupMode;
    }

    public ValidateMigrationInputSqlServerSqlMITaskInput withBackupMode(BackupMode backupMode) {
        this.backupMode = backupMode;
        return this;
    }

    public void validate() {
        if (this.sourceConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceConnectionInfo in model ValidateMigrationInputSqlServerSqlMITaskInput"));
        }
        this.sourceConnectionInfo().validate();
        if (this.targetConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetConnectionInfo in model ValidateMigrationInputSqlServerSqlMITaskInput"));
        }
        this.targetConnectionInfo().validate();
        if (this.selectedDatabases() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property selectedDatabases in model ValidateMigrationInputSqlServerSqlMITaskInput"));
        }
        this.selectedDatabases().forEach(e -> e.validate());
        if (this.backupFileShare() != null) {
            this.backupFileShare().validate();
        }
        if (this.backupBlobShare() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property backupBlobShare in model ValidateMigrationInputSqlServerSqlMITaskInput"));
        }
        this.backupBlobShare().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceConnectionInfo", (JsonSerializable)this.sourceConnectionInfo);
        jsonWriter.writeJsonField("targetConnectionInfo", (JsonSerializable)this.targetConnectionInfo);
        jsonWriter.writeArrayField("selectedDatabases", this.selectedDatabases, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("backupBlobShare", (JsonSerializable)this.backupBlobShare);
        jsonWriter.writeArrayField("selectedLogins", this.selectedLogins, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("backupFileShare", (JsonSerializable)this.backupFileShare);
        jsonWriter.writeStringField("backupMode", this.backupMode == null ? null : this.backupMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static ValidateMigrationInputSqlServerSqlMITaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (ValidateMigrationInputSqlServerSqlMITaskInput)jsonReader.readObject(reader -> {
            ValidateMigrationInputSqlServerSqlMITaskInput deserializedValidateMigrationInputSqlServerSqlMITaskInput = new ValidateMigrationInputSqlServerSqlMITaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceConnectionInfo".equals(fieldName)) {
                    deserializedValidateMigrationInputSqlServerSqlMITaskInput.sourceConnectionInfo = SqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("targetConnectionInfo".equals(fieldName)) {
                    deserializedValidateMigrationInputSqlServerSqlMITaskInput.targetConnectionInfo = SqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("selectedDatabases".equals(fieldName)) {
                    List selectedDatabases;
                    deserializedValidateMigrationInputSqlServerSqlMITaskInput.selectedDatabases = selectedDatabases = reader.readArray(reader1 -> MigrateSqlServerSqlMIDatabaseInput.fromJson(reader1));
                    continue;
                }
                if ("backupBlobShare".equals(fieldName)) {
                    deserializedValidateMigrationInputSqlServerSqlMITaskInput.backupBlobShare = BlobShare.fromJson(reader);
                    continue;
                }
                if ("selectedLogins".equals(fieldName)) {
                    List selectedLogins;
                    deserializedValidateMigrationInputSqlServerSqlMITaskInput.selectedLogins = selectedLogins = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("backupFileShare".equals(fieldName)) {
                    deserializedValidateMigrationInputSqlServerSqlMITaskInput.backupFileShare = FileShare.fromJson(reader);
                    continue;
                }
                if ("backupMode".equals(fieldName)) {
                    deserializedValidateMigrationInputSqlServerSqlMITaskInput.backupMode = BackupMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedValidateMigrationInputSqlServerSqlMITaskInput;
        });
    }
}

