/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ReportableException
implements JsonSerializable<ReportableException> {
    private String message;
    private String actionableMessage;
    private String filePath;
    private String lineNumber;
    private Integer hResult;
    private String stackTrace;

    public String message() {
        return this.message;
    }

    public ReportableException withMessage(String message) {
        this.message = message;
        return this;
    }

    public String actionableMessage() {
        return this.actionableMessage;
    }

    public ReportableException withActionableMessage(String actionableMessage) {
        this.actionableMessage = actionableMessage;
        return this;
    }

    public String filePath() {
        return this.filePath;
    }

    public ReportableException withFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    public String lineNumber() {
        return this.lineNumber;
    }

    public ReportableException withLineNumber(String lineNumber) {
        this.lineNumber = lineNumber;
        return this;
    }

    public Integer hResult() {
        return this.hResult;
    }

    public ReportableException withHResult(Integer hResult) {
        this.hResult = hResult;
        return this;
    }

    public String stackTrace() {
        return this.stackTrace;
    }

    public ReportableException withStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("actionableMessage", this.actionableMessage);
        jsonWriter.writeStringField("filePath", this.filePath);
        jsonWriter.writeStringField("lineNumber", this.lineNumber);
        jsonWriter.writeNumberField("hResult", (Number)this.hResult);
        jsonWriter.writeStringField("stackTrace", this.stackTrace);
        return jsonWriter.writeEndObject();
    }

    public static ReportableException fromJson(JsonReader jsonReader) throws IOException {
        return (ReportableException)jsonReader.readObject(reader -> {
            ReportableException deserializedReportableException = new ReportableException();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("message".equals(fieldName)) {
                    deserializedReportableException.message = reader.getString();
                    continue;
                }
                if ("actionableMessage".equals(fieldName)) {
                    deserializedReportableException.actionableMessage = reader.getString();
                    continue;
                }
                if ("filePath".equals(fieldName)) {
                    deserializedReportableException.filePath = reader.getString();
                    continue;
                }
                if ("lineNumber".equals(fieldName)) {
                    deserializedReportableException.lineNumber = reader.getString();
                    continue;
                }
                if ("hResult".equals(fieldName)) {
                    deserializedReportableException.hResult = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("stackTrace".equals(fieldName)) {
                    deserializedReportableException.stackTrace = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReportableException;
        });
    }
}

