/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlDbSyncDatabaseInput;
import com.azure.resourcemanager.datamigration.models.MigrationValidationOptions;
import com.azure.resourcemanager.datamigration.models.SqlConnectionInfo;
import com.azure.resourcemanager.datamigration.models.SqlMigrationTaskInput;
import java.io.IOException;
import java.util.List;

public final class MigrateSqlServerSqlDbSyncTaskInput
extends SqlMigrationTaskInput {
    private List<MigrateSqlServerSqlDbSyncDatabaseInput> selectedDatabases;
    private MigrationValidationOptions validationOptions;
    private static final ClientLogger LOGGER = new ClientLogger(MigrateSqlServerSqlDbSyncTaskInput.class);

    public List<MigrateSqlServerSqlDbSyncDatabaseInput> selectedDatabases() {
        return this.selectedDatabases;
    }

    public MigrateSqlServerSqlDbSyncTaskInput withSelectedDatabases(List<MigrateSqlServerSqlDbSyncDatabaseInput> selectedDatabases) {
        this.selectedDatabases = selectedDatabases;
        return this;
    }

    public MigrationValidationOptions validationOptions() {
        return this.validationOptions;
    }

    public MigrateSqlServerSqlDbSyncTaskInput withValidationOptions(MigrationValidationOptions validationOptions) {
        this.validationOptions = validationOptions;
        return this;
    }

    @Override
    public MigrateSqlServerSqlDbSyncTaskInput withSourceConnectionInfo(SqlConnectionInfo sourceConnectionInfo) {
        super.withSourceConnectionInfo(sourceConnectionInfo);
        return this;
    }

    @Override
    public MigrateSqlServerSqlDbSyncTaskInput withTargetConnectionInfo(SqlConnectionInfo targetConnectionInfo) {
        super.withTargetConnectionInfo(targetConnectionInfo);
        return this;
    }

    @Override
    public void validate() {
        if (this.selectedDatabases() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property selectedDatabases in model MigrateSqlServerSqlDbSyncTaskInput"));
        }
        this.selectedDatabases().forEach(e -> e.validate());
        if (this.validationOptions() != null) {
            this.validationOptions().validate();
        }
        if (this.sourceConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceConnectionInfo in model MigrateSqlServerSqlDbSyncTaskInput"));
        }
        this.sourceConnectionInfo().validate();
        if (this.targetConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetConnectionInfo in model MigrateSqlServerSqlDbSyncTaskInput"));
        }
        this.targetConnectionInfo().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceConnectionInfo", (JsonSerializable)this.sourceConnectionInfo());
        jsonWriter.writeJsonField("targetConnectionInfo", (JsonSerializable)this.targetConnectionInfo());
        jsonWriter.writeArrayField("selectedDatabases", this.selectedDatabases, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("validationOptions", (JsonSerializable)this.validationOptions);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSqlServerSqlDbSyncTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSqlServerSqlDbSyncTaskInput)jsonReader.readObject(reader -> {
            MigrateSqlServerSqlDbSyncTaskInput deserializedMigrateSqlServerSqlDbSyncTaskInput = new MigrateSqlServerSqlDbSyncTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceConnectionInfo".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskInput.withSourceConnectionInfo(SqlConnectionInfo.fromJson(reader));
                    continue;
                }
                if ("targetConnectionInfo".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskInput.withTargetConnectionInfo(SqlConnectionInfo.fromJson(reader));
                    continue;
                }
                if ("selectedDatabases".equals(fieldName)) {
                    List selectedDatabases;
                    deserializedMigrateSqlServerSqlDbSyncTaskInput.selectedDatabases = selectedDatabases = reader.readArray(reader1 -> MigrateSqlServerSqlDbSyncDatabaseInput.fromJson(reader1));
                    continue;
                }
                if ("validationOptions".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskInput.validationOptions = MigrationValidationOptions.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSqlServerSqlDbSyncTaskInput;
        });
    }
}

