/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.WaitStatistics;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ExecutionStatistics
implements JsonSerializable<ExecutionStatistics> {
    private Long executionCount;
    private Float cpuTimeMs;
    private Float elapsedTimeMs;
    private Map<String, WaitStatistics> waitStats;
    private Boolean hasErrors;
    private List<String> sqlErrors;

    public Long executionCount() {
        return this.executionCount;
    }

    public ExecutionStatistics withExecutionCount(Long executionCount) {
        this.executionCount = executionCount;
        return this;
    }

    public Float cpuTimeMs() {
        return this.cpuTimeMs;
    }

    public ExecutionStatistics withCpuTimeMs(Float cpuTimeMs) {
        this.cpuTimeMs = cpuTimeMs;
        return this;
    }

    public Float elapsedTimeMs() {
        return this.elapsedTimeMs;
    }

    public ExecutionStatistics withElapsedTimeMs(Float elapsedTimeMs) {
        this.elapsedTimeMs = elapsedTimeMs;
        return this;
    }

    public Map<String, WaitStatistics> waitStats() {
        return this.waitStats;
    }

    public ExecutionStatistics withWaitStats(Map<String, WaitStatistics> waitStats) {
        this.waitStats = waitStats;
        return this;
    }

    public Boolean hasErrors() {
        return this.hasErrors;
    }

    public ExecutionStatistics withHasErrors(Boolean hasErrors) {
        this.hasErrors = hasErrors;
        return this;
    }

    public List<String> sqlErrors() {
        return this.sqlErrors;
    }

    public ExecutionStatistics withSqlErrors(List<String> sqlErrors) {
        this.sqlErrors = sqlErrors;
        return this;
    }

    public void validate() {
        if (this.waitStats() != null) {
            this.waitStats().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("executionCount", (Number)this.executionCount);
        jsonWriter.writeNumberField("cpuTimeMs", (Number)this.cpuTimeMs);
        jsonWriter.writeNumberField("elapsedTimeMs", (Number)this.elapsedTimeMs);
        jsonWriter.writeMapField("waitStats", this.waitStats, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("hasErrors", this.hasErrors);
        jsonWriter.writeArrayField("sqlErrors", this.sqlErrors, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ExecutionStatistics fromJson(JsonReader jsonReader) throws IOException {
        return (ExecutionStatistics)jsonReader.readObject(reader -> {
            ExecutionStatistics deserializedExecutionStatistics = new ExecutionStatistics();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("executionCount".equals(fieldName)) {
                    deserializedExecutionStatistics.executionCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("cpuTimeMs".equals(fieldName)) {
                    deserializedExecutionStatistics.cpuTimeMs = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("elapsedTimeMs".equals(fieldName)) {
                    deserializedExecutionStatistics.elapsedTimeMs = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("waitStats".equals(fieldName)) {
                    Map waitStats;
                    deserializedExecutionStatistics.waitStats = waitStats = reader.readMap(reader1 -> WaitStatistics.fromJson(reader1));
                    continue;
                }
                if ("hasErrors".equals(fieldName)) {
                    deserializedExecutionStatistics.hasErrors = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("sqlErrors".equals(fieldName)) {
                    List sqlErrors;
                    deserializedExecutionStatistics.sqlErrors = sqlErrors = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExecutionStatistics;
        });
    }
}

