/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.BackupConfiguration;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationProperties;
import com.azure.resourcemanager.datamigration.models.ErrorInfo;
import com.azure.resourcemanager.datamigration.models.MigrationStatusDetails;
import com.azure.resourcemanager.datamigration.models.OfflineConfiguration;
import com.azure.resourcemanager.datamigration.models.ProvisioningState;
import com.azure.resourcemanager.datamigration.models.ResourceType;
import com.azure.resourcemanager.datamigration.models.SqlConnectionInformation;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class DatabaseMigrationPropertiesSqlMi
extends DatabaseMigrationProperties {
    private ResourceType kind = ResourceType.SQL_MI;
    private MigrationStatusDetails migrationStatusDetails;
    private BackupConfiguration backupConfiguration;
    private OfflineConfiguration offlineConfiguration;

    @Override
    public ResourceType kind() {
        return this.kind;
    }

    public MigrationStatusDetails migrationStatusDetails() {
        return this.migrationStatusDetails;
    }

    public BackupConfiguration backupConfiguration() {
        return this.backupConfiguration;
    }

    public DatabaseMigrationPropertiesSqlMi withBackupConfiguration(BackupConfiguration backupConfiguration) {
        this.backupConfiguration = backupConfiguration;
        return this;
    }

    public OfflineConfiguration offlineConfiguration() {
        return this.offlineConfiguration;
    }

    public DatabaseMigrationPropertiesSqlMi withOfflineConfiguration(OfflineConfiguration offlineConfiguration) {
        this.offlineConfiguration = offlineConfiguration;
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesSqlMi withSourceSqlConnection(SqlConnectionInformation sourceSqlConnection) {
        super.withSourceSqlConnection(sourceSqlConnection);
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesSqlMi withSourceDatabaseName(String sourceDatabaseName) {
        super.withSourceDatabaseName(sourceDatabaseName);
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesSqlMi withTargetDatabaseCollation(String targetDatabaseCollation) {
        super.withTargetDatabaseCollation(targetDatabaseCollation);
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesSqlMi withScope(String scope) {
        super.withScope(scope);
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesSqlMi withMigrationService(String migrationService) {
        super.withMigrationService(migrationService);
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesSqlMi withMigrationOperationId(String migrationOperationId) {
        super.withMigrationOperationId(migrationOperationId);
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesSqlMi withProvisioningError(String provisioningError) {
        super.withProvisioningError(provisioningError);
        return this;
    }

    @Override
    public void validate() {
        if (this.migrationStatusDetails() != null) {
            this.migrationStatusDetails().validate();
        }
        if (this.backupConfiguration() != null) {
            this.backupConfiguration().validate();
        }
        if (this.offlineConfiguration() != null) {
            this.offlineConfiguration().validate();
        }
        if (this.migrationFailureError() != null) {
            this.migrationFailureError().validate();
        }
        if (this.sourceSqlConnection() != null) {
            this.sourceSqlConnection().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scope", this.scope());
        jsonWriter.writeStringField("migrationService", this.migrationService());
        jsonWriter.writeStringField("migrationOperationId", this.migrationOperationId());
        jsonWriter.writeStringField("provisioningError", this.provisioningError());
        jsonWriter.writeJsonField("sourceSqlConnection", (JsonSerializable)this.sourceSqlConnection());
        jsonWriter.writeStringField("sourceDatabaseName", this.sourceDatabaseName());
        jsonWriter.writeStringField("targetDatabaseCollation", this.targetDatabaseCollation());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("backupConfiguration", (JsonSerializable)this.backupConfiguration);
        jsonWriter.writeJsonField("offlineConfiguration", (JsonSerializable)this.offlineConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseMigrationPropertiesSqlMi fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseMigrationPropertiesSqlMi)jsonReader.readObject(reader -> {
            DatabaseMigrationPropertiesSqlMi deserializedDatabaseMigrationPropertiesSqlMi = new DatabaseMigrationPropertiesSqlMi();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scope".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlMi.withScope(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlMi.withProvisioningState(ProvisioningState.fromString(reader.getString()));
                    continue;
                }
                if ("migrationStatus".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlMi.withMigrationStatus(reader.getString());
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlMi.withStartedOn((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlMi.withEndedOn((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("migrationService".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlMi.withMigrationService(reader.getString());
                    continue;
                }
                if ("migrationOperationId".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlMi.withMigrationOperationId(reader.getString());
                    continue;
                }
                if ("migrationFailureError".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlMi.withMigrationFailureError(ErrorInfo.fromJson(reader));
                    continue;
                }
                if ("provisioningError".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlMi.withProvisioningError(reader.getString());
                    continue;
                }
                if ("sourceSqlConnection".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlMi.withSourceSqlConnection(SqlConnectionInformation.fromJson(reader));
                    continue;
                }
                if ("sourceDatabaseName".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlMi.withSourceDatabaseName(reader.getString());
                    continue;
                }
                if ("sourceServerName".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlMi.withSourceServerName(reader.getString());
                    continue;
                }
                if ("targetDatabaseCollation".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlMi.withTargetDatabaseCollation(reader.getString());
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlMi.kind = ResourceType.fromString(reader.getString());
                    continue;
                }
                if ("migrationStatusDetails".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlMi.migrationStatusDetails = MigrationStatusDetails.fromJson(reader);
                    continue;
                }
                if ("backupConfiguration".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlMi.backupConfiguration = BackupConfiguration.fromJson(reader);
                    continue;
                }
                if ("offlineConfiguration".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlMi.offlineConfiguration = OfflineConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseMigrationPropertiesSqlMi;
        });
    }
}

