/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationProperties;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationPropertiesCosmosDbMongo;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationPropertiesSqlDb;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationPropertiesSqlMi;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationPropertiesSqlVm;
import com.azure.resourcemanager.datamigration.models.ErrorInfo;
import com.azure.resourcemanager.datamigration.models.ProvisioningState;
import com.azure.resourcemanager.datamigration.models.ResourceType;
import java.io.IOException;
import java.time.OffsetDateTime;

public class DatabaseMigrationBaseProperties
implements JsonSerializable<DatabaseMigrationBaseProperties> {
    private ResourceType kind = ResourceType.fromString("DatabaseMigrationBaseProperties");
    private String scope;
    private ProvisioningState provisioningState;
    private String migrationStatus;
    private OffsetDateTime startedOn;
    private OffsetDateTime endedOn;
    private String migrationService;
    private String migrationOperationId;
    private ErrorInfo migrationFailureError;
    private String provisioningError;

    public ResourceType kind() {
        return this.kind;
    }

    public String scope() {
        return this.scope;
    }

    public DatabaseMigrationBaseProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    DatabaseMigrationBaseProperties withProvisioningState(ProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public String migrationStatus() {
        return this.migrationStatus;
    }

    DatabaseMigrationBaseProperties withMigrationStatus(String migrationStatus) {
        this.migrationStatus = migrationStatus;
        return this;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    DatabaseMigrationBaseProperties withStartedOn(OffsetDateTime startedOn) {
        this.startedOn = startedOn;
        return this;
    }

    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    DatabaseMigrationBaseProperties withEndedOn(OffsetDateTime endedOn) {
        this.endedOn = endedOn;
        return this;
    }

    public String migrationService() {
        return this.migrationService;
    }

    public DatabaseMigrationBaseProperties withMigrationService(String migrationService) {
        this.migrationService = migrationService;
        return this;
    }

    public String migrationOperationId() {
        return this.migrationOperationId;
    }

    public DatabaseMigrationBaseProperties withMigrationOperationId(String migrationOperationId) {
        this.migrationOperationId = migrationOperationId;
        return this;
    }

    public ErrorInfo migrationFailureError() {
        return this.migrationFailureError;
    }

    DatabaseMigrationBaseProperties withMigrationFailureError(ErrorInfo migrationFailureError) {
        this.migrationFailureError = migrationFailureError;
        return this;
    }

    public String provisioningError() {
        return this.provisioningError;
    }

    public DatabaseMigrationBaseProperties withProvisioningError(String provisioningError) {
        this.provisioningError = provisioningError;
        return this;
    }

    public void validate() {
        if (this.migrationFailureError() != null) {
            this.migrationFailureError().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("scope", this.scope);
        jsonWriter.writeStringField("migrationService", this.migrationService);
        jsonWriter.writeStringField("migrationOperationId", this.migrationOperationId);
        jsonWriter.writeStringField("provisioningError", this.provisioningError);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseMigrationBaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseMigrationBaseProperties)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                DatabaseMigrationBaseProperties databaseMigrationBaseProperties;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("MongoToCosmosDbMongo".equals(discriminatorValue)) {
                    databaseMigrationBaseProperties = DatabaseMigrationPropertiesCosmosDbMongo.fromJson(readerToUse.reset());
                    return databaseMigrationBaseProperties;
                }
                if ("DatabaseMigrationProperties".equals(discriminatorValue)) {
                    databaseMigrationBaseProperties = DatabaseMigrationProperties.fromJsonKnownDiscriminator(readerToUse.reset());
                    return databaseMigrationBaseProperties;
                }
                if ("SqlDb".equals(discriminatorValue)) {
                    databaseMigrationBaseProperties = DatabaseMigrationPropertiesSqlDb.fromJson(readerToUse.reset());
                    return databaseMigrationBaseProperties;
                }
                if ("SqlMi".equals(discriminatorValue)) {
                    databaseMigrationBaseProperties = DatabaseMigrationPropertiesSqlMi.fromJson(readerToUse.reset());
                    return databaseMigrationBaseProperties;
                }
                if ("SqlVm".equals(discriminatorValue)) {
                    databaseMigrationBaseProperties = DatabaseMigrationPropertiesSqlVm.fromJson(readerToUse.reset());
                    return databaseMigrationBaseProperties;
                }
                databaseMigrationBaseProperties = DatabaseMigrationBaseProperties.fromJsonKnownDiscriminator(readerToUse.reset());
                return databaseMigrationBaseProperties;
            }
        });
    }

    static DatabaseMigrationBaseProperties fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (DatabaseMigrationBaseProperties)jsonReader.readObject(reader -> {
            DatabaseMigrationBaseProperties deserializedDatabaseMigrationBaseProperties = new DatabaseMigrationBaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    deserializedDatabaseMigrationBaseProperties.kind = ResourceType.fromString(reader.getString());
                    continue;
                }
                if ("scope".equals(fieldName)) {
                    deserializedDatabaseMigrationBaseProperties.scope = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDatabaseMigrationBaseProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("migrationStatus".equals(fieldName)) {
                    deserializedDatabaseMigrationBaseProperties.migrationStatus = reader.getString();
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedDatabaseMigrationBaseProperties.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedDatabaseMigrationBaseProperties.endedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("migrationService".equals(fieldName)) {
                    deserializedDatabaseMigrationBaseProperties.migrationService = reader.getString();
                    continue;
                }
                if ("migrationOperationId".equals(fieldName)) {
                    deserializedDatabaseMigrationBaseProperties.migrationOperationId = reader.getString();
                    continue;
                }
                if ("migrationFailureError".equals(fieldName)) {
                    deserializedDatabaseMigrationBaseProperties.migrationFailureError = ErrorInfo.fromJson(reader);
                    continue;
                }
                if ("provisioningError".equals(fieldName)) {
                    deserializedDatabaseMigrationBaseProperties.provisioningError = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseMigrationBaseProperties;
        });
    }
}

