/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.BackupType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class DatabaseBackupInfo
implements JsonSerializable<DatabaseBackupInfo> {
    private String databaseName;
    private BackupType backupType;
    private List<String> backupFiles;
    private Integer position;
    private Boolean isDamaged;
    private Boolean isCompressed;
    private Integer familyCount;
    private OffsetDateTime backupFinishDate;

    public String databaseName() {
        return this.databaseName;
    }

    public BackupType backupType() {
        return this.backupType;
    }

    public List<String> backupFiles() {
        return this.backupFiles;
    }

    public Integer position() {
        return this.position;
    }

    public Boolean isDamaged() {
        return this.isDamaged;
    }

    public Boolean isCompressed() {
        return this.isCompressed;
    }

    public Integer familyCount() {
        return this.familyCount;
    }

    public OffsetDateTime backupFinishDate() {
        return this.backupFinishDate;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static DatabaseBackupInfo fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseBackupInfo)jsonReader.readObject(reader -> {
            DatabaseBackupInfo deserializedDatabaseBackupInfo = new DatabaseBackupInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("databaseName".equals(fieldName)) {
                    deserializedDatabaseBackupInfo.databaseName = reader.getString();
                    continue;
                }
                if ("backupType".equals(fieldName)) {
                    deserializedDatabaseBackupInfo.backupType = BackupType.fromString(reader.getString());
                    continue;
                }
                if ("backupFiles".equals(fieldName)) {
                    List backupFiles;
                    deserializedDatabaseBackupInfo.backupFiles = backupFiles = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("position".equals(fieldName)) {
                    deserializedDatabaseBackupInfo.position = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("isDamaged".equals(fieldName)) {
                    deserializedDatabaseBackupInfo.isDamaged = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isCompressed".equals(fieldName)) {
                    deserializedDatabaseBackupInfo.isCompressed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("familyCount".equals(fieldName)) {
                    deserializedDatabaseBackupInfo.familyCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("backupFinishDate".equals(fieldName)) {
                    deserializedDatabaseBackupInfo.backupFinishDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseBackupInfo;
        });
    }
}

