/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MySqlConnectionInfo;
import com.azure.resourcemanager.datamigration.models.MySqlTargetPlatformType;
import com.azure.resourcemanager.datamigration.models.ServerLevelPermissionsGroup;
import java.io.IOException;

public final class ConnectToSourceMySqlTaskInput
implements JsonSerializable<ConnectToSourceMySqlTaskInput> {
    private MySqlConnectionInfo sourceConnectionInfo;
    private MySqlTargetPlatformType targetPlatform;
    private ServerLevelPermissionsGroup checkPermissionsGroup;
    private Boolean isOfflineMigration;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectToSourceMySqlTaskInput.class);

    public MySqlConnectionInfo sourceConnectionInfo() {
        return this.sourceConnectionInfo;
    }

    public ConnectToSourceMySqlTaskInput withSourceConnectionInfo(MySqlConnectionInfo sourceConnectionInfo) {
        this.sourceConnectionInfo = sourceConnectionInfo;
        return this;
    }

    public MySqlTargetPlatformType targetPlatform() {
        return this.targetPlatform;
    }

    public ConnectToSourceMySqlTaskInput withTargetPlatform(MySqlTargetPlatformType targetPlatform) {
        this.targetPlatform = targetPlatform;
        return this;
    }

    public ServerLevelPermissionsGroup checkPermissionsGroup() {
        return this.checkPermissionsGroup;
    }

    public ConnectToSourceMySqlTaskInput withCheckPermissionsGroup(ServerLevelPermissionsGroup checkPermissionsGroup) {
        this.checkPermissionsGroup = checkPermissionsGroup;
        return this;
    }

    public Boolean isOfflineMigration() {
        return this.isOfflineMigration;
    }

    public ConnectToSourceMySqlTaskInput withIsOfflineMigration(Boolean isOfflineMigration) {
        this.isOfflineMigration = isOfflineMigration;
        return this;
    }

    public void validate() {
        if (this.sourceConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceConnectionInfo in model ConnectToSourceMySqlTaskInput"));
        }
        this.sourceConnectionInfo().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceConnectionInfo", (JsonSerializable)this.sourceConnectionInfo);
        jsonWriter.writeStringField("targetPlatform", this.targetPlatform == null ? null : this.targetPlatform.toString());
        jsonWriter.writeStringField("checkPermissionsGroup", this.checkPermissionsGroup == null ? null : this.checkPermissionsGroup.toString());
        jsonWriter.writeBooleanField("isOfflineMigration", this.isOfflineMigration);
        return jsonWriter.writeEndObject();
    }

    public static ConnectToSourceMySqlTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectToSourceMySqlTaskInput)jsonReader.readObject(reader -> {
            ConnectToSourceMySqlTaskInput deserializedConnectToSourceMySqlTaskInput = new ConnectToSourceMySqlTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceConnectionInfo".equals(fieldName)) {
                    deserializedConnectToSourceMySqlTaskInput.sourceConnectionInfo = MySqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("targetPlatform".equals(fieldName)) {
                    deserializedConnectToSourceMySqlTaskInput.targetPlatform = MySqlTargetPlatformType.fromString(reader.getString());
                    continue;
                }
                if ("checkPermissionsGroup".equals(fieldName)) {
                    deserializedConnectToSourceMySqlTaskInput.checkPermissionsGroup = ServerLevelPermissionsGroup.fromString(reader.getString());
                    continue;
                }
                if ("isOfflineMigration".equals(fieldName)) {
                    deserializedConnectToSourceMySqlTaskInput.isOfflineMigration = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectToSourceMySqlTaskInput;
        });
    }
}

