/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datamigration.DataMigrationManager;
import com.azure.resourcemanager.datamigration.fluent.models.DeleteNodeInner;
import com.azure.resourcemanager.datamigration.fluent.models.RegenAuthKeysInner;
import com.azure.resourcemanager.datamigration.fluent.models.SqlMigrationServiceInner;
import com.azure.resourcemanager.datamigration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datamigration.models.AuthenticationKeys;
import com.azure.resourcemanager.datamigration.models.DeleteNode;
import com.azure.resourcemanager.datamigration.models.IntegrationRuntimeMonitoringData;
import com.azure.resourcemanager.datamigration.models.RegenAuthKeys;
import com.azure.resourcemanager.datamigration.models.SqlMigrationService;
import com.azure.resourcemanager.datamigration.models.SqlMigrationServiceUpdate;
import com.azure.resourcemanager.datamigration.models.SystemDataAutoGenerated;
import java.util.Collections;
import java.util.Map;

public final class SqlMigrationServiceImpl
implements SqlMigrationService,
SqlMigrationService.Definition,
SqlMigrationService.Update {
    private SqlMigrationServiceInner innerObject;
    private final DataMigrationManager serviceManager;
    private String resourceGroupName;
    private String sqlMigrationServiceName;
    private SqlMigrationServiceUpdate updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SystemDataAutoGenerated systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String integrationRuntimeState() {
        return this.innerModel().integrationRuntimeState();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SqlMigrationServiceInner innerModel() {
        return this.innerObject;
    }

    private DataMigrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public SqlMigrationServiceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public SqlMigrationService create() {
        this.innerObject = this.serviceManager.serviceClient().getSqlMigrationServices().createOrUpdate(this.resourceGroupName, this.sqlMigrationServiceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public SqlMigrationService create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSqlMigrationServices().createOrUpdate(this.resourceGroupName, this.sqlMigrationServiceName, this.innerModel(), context);
        return this;
    }

    SqlMigrationServiceImpl(String name, DataMigrationManager serviceManager) {
        this.innerObject = new SqlMigrationServiceInner();
        this.serviceManager = serviceManager;
        this.sqlMigrationServiceName = name;
    }

    @Override
    public SqlMigrationServiceImpl update() {
        this.updateParameters = new SqlMigrationServiceUpdate();
        return this;
    }

    @Override
    public SqlMigrationService apply() {
        this.innerObject = this.serviceManager.serviceClient().getSqlMigrationServices().update(this.resourceGroupName, this.sqlMigrationServiceName, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public SqlMigrationService apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSqlMigrationServices().update(this.resourceGroupName, this.sqlMigrationServiceName, this.updateParameters, context);
        return this;
    }

    SqlMigrationServiceImpl(SqlMigrationServiceInner innerObject, DataMigrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.sqlMigrationServiceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "sqlMigrationServices");
    }

    @Override
    public SqlMigrationService refresh() {
        this.innerObject = (SqlMigrationServiceInner)((Object)this.serviceManager.serviceClient().getSqlMigrationServices().getByResourceGroupWithResponse(this.resourceGroupName, this.sqlMigrationServiceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public SqlMigrationService refresh(Context context) {
        this.innerObject = (SqlMigrationServiceInner)((Object)this.serviceManager.serviceClient().getSqlMigrationServices().getByResourceGroupWithResponse(this.resourceGroupName, this.sqlMigrationServiceName, context).getValue());
        return this;
    }

    @Override
    public Response<AuthenticationKeys> listAuthKeysWithResponse(Context context) {
        return this.serviceManager.sqlMigrationServices().listAuthKeysWithResponse(this.resourceGroupName, this.sqlMigrationServiceName, context);
    }

    @Override
    public AuthenticationKeys listAuthKeys() {
        return this.serviceManager.sqlMigrationServices().listAuthKeys(this.resourceGroupName, this.sqlMigrationServiceName);
    }

    @Override
    public Response<RegenAuthKeys> regenerateAuthKeysWithResponse(RegenAuthKeysInner parameters, Context context) {
        return this.serviceManager.sqlMigrationServices().regenerateAuthKeysWithResponse(this.resourceGroupName, this.sqlMigrationServiceName, parameters, context);
    }

    @Override
    public RegenAuthKeys regenerateAuthKeys(RegenAuthKeysInner parameters) {
        return this.serviceManager.sqlMigrationServices().regenerateAuthKeys(this.resourceGroupName, this.sqlMigrationServiceName, parameters);
    }

    @Override
    public Response<DeleteNode> deleteNodeWithResponse(DeleteNodeInner parameters, Context context) {
        return this.serviceManager.sqlMigrationServices().deleteNodeWithResponse(this.resourceGroupName, this.sqlMigrationServiceName, parameters, context);
    }

    @Override
    public DeleteNode deleteNode(DeleteNodeInner parameters) {
        return this.serviceManager.sqlMigrationServices().deleteNode(this.resourceGroupName, this.sqlMigrationServiceName, parameters);
    }

    @Override
    public Response<IntegrationRuntimeMonitoringData> listMonitoringDataWithResponse(Context context) {
        return this.serviceManager.sqlMigrationServices().listMonitoringDataWithResponse(this.resourceGroupName, this.sqlMigrationServiceName, context);
    }

    @Override
    public IntegrationRuntimeMonitoringData listMonitoringData() {
        return this.serviceManager.sqlMigrationServices().listMonitoringData(this.resourceGroupName, this.sqlMigrationServiceName);
    }

    @Override
    public SqlMigrationServiceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public SqlMigrationServiceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public SqlMigrationServiceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

