/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.datamigration.DataMigrationManager;
import com.azure.resourcemanager.datamigration.fluent.models.DatabaseMigrationSqlDbInner;
import com.azure.resourcemanager.datamigration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationPropertiesSqlDb;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationSqlDb;
import com.azure.resourcemanager.datamigration.models.MigrationOperationInput;
import com.azure.resourcemanager.datamigration.models.SystemDataAutoGenerated;
import java.util.UUID;

public final class DatabaseMigrationSqlDbImpl
implements DatabaseMigrationSqlDb,
DatabaseMigrationSqlDb.Definition,
DatabaseMigrationSqlDb.Update {
    private DatabaseMigrationSqlDbInner innerObject;
    private final DataMigrationManager serviceManager;
    private String resourceGroupName;
    private String sqlDbInstanceName;
    private String targetDbName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public DatabaseMigrationPropertiesSqlDb properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemDataAutoGenerated systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DatabaseMigrationSqlDbInner innerModel() {
        return this.innerObject;
    }

    private DataMigrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public DatabaseMigrationSqlDbImpl withExistingServer(String resourceGroupName, String sqlDbInstanceName) {
        this.resourceGroupName = resourceGroupName;
        this.sqlDbInstanceName = sqlDbInstanceName;
        return this;
    }

    @Override
    public DatabaseMigrationSqlDb create() {
        this.innerObject = this.serviceManager.serviceClient().getDatabaseMigrationsSqlDbs().createOrUpdate(this.resourceGroupName, this.sqlDbInstanceName, this.targetDbName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public DatabaseMigrationSqlDb create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDatabaseMigrationsSqlDbs().createOrUpdate(this.resourceGroupName, this.sqlDbInstanceName, this.targetDbName, this.innerModel(), context);
        return this;
    }

    DatabaseMigrationSqlDbImpl(String name, DataMigrationManager serviceManager) {
        this.innerObject = new DatabaseMigrationSqlDbInner();
        this.serviceManager = serviceManager;
        this.targetDbName = name;
    }

    @Override
    public DatabaseMigrationSqlDbImpl update() {
        return this;
    }

    @Override
    public DatabaseMigrationSqlDb apply() {
        this.innerObject = this.serviceManager.serviceClient().getDatabaseMigrationsSqlDbs().createOrUpdate(this.resourceGroupName, this.sqlDbInstanceName, this.targetDbName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public DatabaseMigrationSqlDb apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDatabaseMigrationsSqlDbs().createOrUpdate(this.resourceGroupName, this.sqlDbInstanceName, this.targetDbName, this.innerModel(), context);
        return this;
    }

    DatabaseMigrationSqlDbImpl(DatabaseMigrationSqlDbInner innerObject, DataMigrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.sqlDbInstanceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "servers");
        this.targetDbName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "databaseMigrations");
    }

    @Override
    public DatabaseMigrationSqlDb refresh() {
        UUID localMigrationOperationId = null;
        String localExpand = null;
        this.innerObject = (DatabaseMigrationSqlDbInner)((Object)this.serviceManager.serviceClient().getDatabaseMigrationsSqlDbs().getWithResponse(this.resourceGroupName, this.sqlDbInstanceName, this.targetDbName, localMigrationOperationId, localExpand, Context.NONE).getValue());
        return this;
    }

    @Override
    public DatabaseMigrationSqlDb refresh(Context context) {
        UUID localMigrationOperationId = null;
        String localExpand = null;
        this.innerObject = (DatabaseMigrationSqlDbInner)((Object)this.serviceManager.serviceClient().getDatabaseMigrationsSqlDbs().getWithResponse(this.resourceGroupName, this.sqlDbInstanceName, this.targetDbName, localMigrationOperationId, localExpand, context).getValue());
        return this;
    }

    @Override
    public void cancel(MigrationOperationInput parameters) {
        this.serviceManager.databaseMigrationsSqlDbs().cancel(this.resourceGroupName, this.sqlDbInstanceName, this.targetDbName, parameters);
    }

    @Override
    public void cancel(MigrationOperationInput parameters, Context context) {
        this.serviceManager.databaseMigrationsSqlDbs().cancel(this.resourceGroupName, this.sqlDbInstanceName, this.targetDbName, parameters, context);
    }

    @Override
    public DatabaseMigrationSqlDb retry(MigrationOperationInput migrationOperationInput) {
        return this.serviceManager.databaseMigrationsSqlDbs().retry(this.resourceGroupName, this.sqlDbInstanceName, this.targetDbName, migrationOperationInput);
    }

    @Override
    public DatabaseMigrationSqlDb retry(MigrationOperationInput migrationOperationInput, Context context) {
        return this.serviceManager.databaseMigrationsSqlDbs().retry(this.resourceGroupName, this.sqlDbInstanceName, this.targetDbName, migrationOperationInput, context);
    }

    @Override
    public DatabaseMigrationSqlDbImpl withProperties(DatabaseMigrationPropertiesSqlDb properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

