/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationProperties;
import java.io.IOException;

public final class DatabaseMigrationInner
extends ProxyResource {
    private DatabaseMigrationProperties properties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public DatabaseMigrationProperties properties() {
        return this.properties;
    }

    public DatabaseMigrationInner withProperties(DatabaseMigrationProperties properties) {
        this.properties = properties;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseMigrationInner fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseMigrationInner)((Object)jsonReader.readObject(reader -> {
            DatabaseMigrationInner deserializedDatabaseMigrationInner = new DatabaseMigrationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDatabaseMigrationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDatabaseMigrationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDatabaseMigrationInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDatabaseMigrationInner.properties = DatabaseMigrationProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedDatabaseMigrationInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseMigrationInner;
        }));
    }
}

