/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.Severity;
import java.io.IOException;

public final class ValidationError
implements JsonSerializable<ValidationError> {
    private String text;
    private Severity severity;

    public String text() {
        return this.text;
    }

    public ValidationError withText(String text) {
        this.text = text;
        return this;
    }

    public Severity severity() {
        return this.severity;
    }

    public ValidationError withSeverity(Severity severity) {
        this.severity = severity;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("severity", this.severity == null ? null : this.severity.toString());
        return jsonWriter.writeEndObject();
    }

    public static ValidationError fromJson(JsonReader jsonReader) throws IOException {
        return (ValidationError)jsonReader.readObject(reader -> {
            ValidationError deserializedValidationError = new ValidationError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    deserializedValidationError.text = reader.getString();
                    continue;
                }
                if ("severity".equals(fieldName)) {
                    deserializedValidationError.severity = Severity.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedValidationError;
        });
    }
}

