/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ProjectFileProperties
implements JsonSerializable<ProjectFileProperties> {
    private String extension;
    private String filePath;
    private OffsetDateTime lastModified;
    private String mediaType;
    private Long size;

    public String extension() {
        return this.extension;
    }

    public ProjectFileProperties withExtension(String extension) {
        this.extension = extension;
        return this;
    }

    public String filePath() {
        return this.filePath;
    }

    public ProjectFileProperties withFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    public OffsetDateTime lastModified() {
        return this.lastModified;
    }

    public String mediaType() {
        return this.mediaType;
    }

    public ProjectFileProperties withMediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public Long size() {
        return this.size;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("extension", this.extension);
        jsonWriter.writeStringField("filePath", this.filePath);
        jsonWriter.writeStringField("mediaType", this.mediaType);
        return jsonWriter.writeEndObject();
    }

    public static ProjectFileProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ProjectFileProperties)jsonReader.readObject(reader -> {
            ProjectFileProperties deserializedProjectFileProperties = new ProjectFileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("extension".equals(fieldName)) {
                    deserializedProjectFileProperties.extension = reader.getString();
                    continue;
                }
                if ("filePath".equals(fieldName)) {
                    deserializedProjectFileProperties.filePath = reader.getString();
                    continue;
                }
                if ("lastModified".equals(fieldName)) {
                    deserializedProjectFileProperties.lastModified = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("mediaType".equals(fieldName)) {
                    deserializedProjectFileProperties.mediaType = reader.getString();
                    continue;
                }
                if ("size".equals(fieldName)) {
                    deserializedProjectFileProperties.size = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProjectFileProperties;
        });
    }
}

