/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MongoDbCollectionProgress;
import com.azure.resourcemanager.datamigration.models.MongoDbError;
import com.azure.resourcemanager.datamigration.models.MongoDbMigrationState;
import com.azure.resourcemanager.datamigration.models.MongoDbProgress;
import com.azure.resourcemanager.datamigration.models.MongoDbProgressResultType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class MongoDbDatabaseProgress
extends MongoDbProgress {
    private MongoDbProgressResultType resultType = MongoDbProgressResultType.DATABASE;
    private Map<String, MongoDbCollectionProgress> collections;
    private static final ClientLogger LOGGER = new ClientLogger(MongoDbDatabaseProgress.class);

    @Override
    public MongoDbProgressResultType resultType() {
        return this.resultType;
    }

    public Map<String, MongoDbCollectionProgress> collections() {
        return this.collections;
    }

    public MongoDbDatabaseProgress withCollections(Map<String, MongoDbCollectionProgress> collections) {
        this.collections = collections;
        return this;
    }

    @Override
    public MongoDbDatabaseProgress withBytesCopied(long bytesCopied) {
        super.withBytesCopied(bytesCopied);
        return this;
    }

    @Override
    public MongoDbDatabaseProgress withDocumentsCopied(long documentsCopied) {
        super.withDocumentsCopied(documentsCopied);
        return this;
    }

    @Override
    public MongoDbDatabaseProgress withElapsedTime(String elapsedTime) {
        super.withElapsedTime(elapsedTime);
        return this;
    }

    @Override
    public MongoDbDatabaseProgress withErrors(Map<String, MongoDbError> errors) {
        super.withErrors(errors);
        return this;
    }

    @Override
    public MongoDbDatabaseProgress withEventsPending(long eventsPending) {
        super.withEventsPending(eventsPending);
        return this;
    }

    @Override
    public MongoDbDatabaseProgress withEventsReplayed(long eventsReplayed) {
        super.withEventsReplayed(eventsReplayed);
        return this;
    }

    @Override
    public MongoDbDatabaseProgress withLastEventTime(OffsetDateTime lastEventTime) {
        super.withLastEventTime(lastEventTime);
        return this;
    }

    @Override
    public MongoDbDatabaseProgress withLastReplayTime(OffsetDateTime lastReplayTime) {
        super.withLastReplayTime(lastReplayTime);
        return this;
    }

    @Override
    public MongoDbDatabaseProgress withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public MongoDbDatabaseProgress withQualifiedName(String qualifiedName) {
        super.withQualifiedName(qualifiedName);
        return this;
    }

    @Override
    public MongoDbDatabaseProgress withState(MongoDbMigrationState state) {
        super.withState(state);
        return this;
    }

    @Override
    public MongoDbDatabaseProgress withTotalBytes(long totalBytes) {
        super.withTotalBytes(totalBytes);
        return this;
    }

    @Override
    public MongoDbDatabaseProgress withTotalDocuments(long totalDocuments) {
        super.withTotalDocuments(totalDocuments);
        return this;
    }

    @Override
    public void validate() {
        if (this.collections() != null) {
            this.collections().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.elapsedTime() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property elapsedTime in model MongoDbDatabaseProgress"));
        }
        if (this.errors() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property errors in model MongoDbDatabaseProgress"));
        }
        this.errors().values().forEach(e -> {
            if (e != null) {
                e.validate();
            }
        });
        if (this.state() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property state in model MongoDbDatabaseProgress"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("bytesCopied", this.bytesCopied());
        jsonWriter.writeLongField("documentsCopied", this.documentsCopied());
        jsonWriter.writeStringField("elapsedTime", this.elapsedTime());
        jsonWriter.writeMapField("errors", this.errors(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeLongField("eventsPending", this.eventsPending());
        jsonWriter.writeLongField("eventsReplayed", this.eventsReplayed());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeLongField("totalBytes", this.totalBytes());
        jsonWriter.writeLongField("totalDocuments", this.totalDocuments());
        jsonWriter.writeStringField("lastEventTime", this.lastEventTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastEventTime()));
        jsonWriter.writeStringField("lastReplayTime", this.lastReplayTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastReplayTime()));
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("qualifiedName", this.qualifiedName());
        jsonWriter.writeStringField("resultType", this.resultType == null ? null : this.resultType.toString());
        jsonWriter.writeMapField("collections", this.collections, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MongoDbDatabaseProgress fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDbDatabaseProgress)jsonReader.readObject(reader -> {
            MongoDbDatabaseProgress deserializedMongoDbDatabaseProgress = new MongoDbDatabaseProgress();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("bytesCopied".equals(fieldName)) {
                    deserializedMongoDbDatabaseProgress.withBytesCopied(reader.getLong());
                    continue;
                }
                if ("documentsCopied".equals(fieldName)) {
                    deserializedMongoDbDatabaseProgress.withDocumentsCopied(reader.getLong());
                    continue;
                }
                if ("elapsedTime".equals(fieldName)) {
                    deserializedMongoDbDatabaseProgress.withElapsedTime(reader.getString());
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    Map errors = reader.readMap(reader1 -> MongoDbError.fromJson(reader1));
                    deserializedMongoDbDatabaseProgress.withErrors(errors);
                    continue;
                }
                if ("eventsPending".equals(fieldName)) {
                    deserializedMongoDbDatabaseProgress.withEventsPending(reader.getLong());
                    continue;
                }
                if ("eventsReplayed".equals(fieldName)) {
                    deserializedMongoDbDatabaseProgress.withEventsReplayed(reader.getLong());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMongoDbDatabaseProgress.withState(MongoDbMigrationState.fromString(reader.getString()));
                    continue;
                }
                if ("totalBytes".equals(fieldName)) {
                    deserializedMongoDbDatabaseProgress.withTotalBytes(reader.getLong());
                    continue;
                }
                if ("totalDocuments".equals(fieldName)) {
                    deserializedMongoDbDatabaseProgress.withTotalDocuments(reader.getLong());
                    continue;
                }
                if ("lastEventTime".equals(fieldName)) {
                    deserializedMongoDbDatabaseProgress.withLastEventTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("lastReplayTime".equals(fieldName)) {
                    deserializedMongoDbDatabaseProgress.withLastReplayTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMongoDbDatabaseProgress.withName(reader.getString());
                    continue;
                }
                if ("qualifiedName".equals(fieldName)) {
                    deserializedMongoDbDatabaseProgress.withQualifiedName(reader.getString());
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedMongoDbDatabaseProgress.resultType = MongoDbProgressResultType.fromString(reader.getString());
                    continue;
                }
                if ("collections".equals(fieldName)) {
                    Map collections;
                    deserializedMongoDbDatabaseProgress.collections = collections = reader.readMap(reader1 -> MongoDbCollectionProgress.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoDbDatabaseProgress;
        });
    }
}

