/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.fluent.models.CommandPropertiesInner;
import com.azure.resourcemanager.datamigration.models.GetTdeCertificatesSqlTaskInput;
import com.azure.resourcemanager.datamigration.models.GetTdeCertificatesSqlTaskOutput;
import com.azure.resourcemanager.datamigration.models.ProjectTaskProperties;
import com.azure.resourcemanager.datamigration.models.TaskState;
import com.azure.resourcemanager.datamigration.models.TaskType;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class GetTdeCertificatesSqlTaskProperties
extends ProjectTaskProperties {
    private TaskType taskType = TaskType.GET_TDECERTIFICATES_SQL;
    private GetTdeCertificatesSqlTaskInput input;
    private List<GetTdeCertificatesSqlTaskOutput> output;

    @Override
    public TaskType taskType() {
        return this.taskType;
    }

    public GetTdeCertificatesSqlTaskInput input() {
        return this.input;
    }

    public GetTdeCertificatesSqlTaskProperties withInput(GetTdeCertificatesSqlTaskInput input) {
        this.input = input;
        return this;
    }

    public List<GetTdeCertificatesSqlTaskOutput> output() {
        return this.output;
    }

    @Override
    public GetTdeCertificatesSqlTaskProperties withClientData(Map<String, String> clientData) {
        super.withClientData(clientData);
        return this;
    }

    @Override
    public void validate() {
        if (this.input() != null) {
            this.input().validate();
        }
        if (this.output() != null) {
            this.output().forEach(e -> e.validate());
        }
        if (this.commands() != null) {
            this.commands().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("clientData", this.clientData(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("taskType", this.taskType == null ? null : this.taskType.toString());
        jsonWriter.writeJsonField("input", (JsonSerializable)this.input);
        return jsonWriter.writeEndObject();
    }

    public static GetTdeCertificatesSqlTaskProperties fromJson(JsonReader jsonReader) throws IOException {
        return (GetTdeCertificatesSqlTaskProperties)jsonReader.readObject(reader -> {
            GetTdeCertificatesSqlTaskProperties deserializedGetTdeCertificatesSqlTaskProperties = new GetTdeCertificatesSqlTaskProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errors".equals(fieldName)) {
                    List errors = reader.readArray(reader1 -> ManagementError.fromJson((JsonReader)reader1));
                    deserializedGetTdeCertificatesSqlTaskProperties.withErrors(errors);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedGetTdeCertificatesSqlTaskProperties.withState(TaskState.fromString(reader.getString()));
                    continue;
                }
                if ("commands".equals(fieldName)) {
                    List commands = reader.readArray(reader1 -> CommandPropertiesInner.fromJson(reader1));
                    deserializedGetTdeCertificatesSqlTaskProperties.withCommands(commands);
                    continue;
                }
                if ("clientData".equals(fieldName)) {
                    Map clientData = reader.readMap(reader1 -> reader1.getString());
                    deserializedGetTdeCertificatesSqlTaskProperties.withClientData(clientData);
                    continue;
                }
                if ("taskType".equals(fieldName)) {
                    deserializedGetTdeCertificatesSqlTaskProperties.taskType = TaskType.fromString(reader.getString());
                    continue;
                }
                if ("input".equals(fieldName)) {
                    deserializedGetTdeCertificatesSqlTaskProperties.input = GetTdeCertificatesSqlTaskInput.fromJson(reader);
                    continue;
                }
                if ("output".equals(fieldName)) {
                    List output;
                    deserializedGetTdeCertificatesSqlTaskProperties.output = output = reader.readArray(reader1 -> GetTdeCertificatesSqlTaskOutput.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGetTdeCertificatesSqlTaskProperties;
        });
    }
}

