/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.DataItemMigrationSummaryResult;
import com.azure.resourcemanager.datamigration.models.MigrationState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class DatabaseSummaryResult
extends DataItemMigrationSummaryResult {
    private Double sizeMB;
    private String resultPrefix;
    private String errorPrefix;
    private Long itemsCompletedCount;
    private Long itemsCount;
    private String statusMessage;
    private MigrationState state;
    private OffsetDateTime endedOn;
    private OffsetDateTime startedOn;
    private String name;

    public Double sizeMB() {
        return this.sizeMB;
    }

    @Override
    public String resultPrefix() {
        return this.resultPrefix;
    }

    @Override
    public String errorPrefix() {
        return this.errorPrefix;
    }

    @Override
    public Long itemsCompletedCount() {
        return this.itemsCompletedCount;
    }

    @Override
    public Long itemsCount() {
        return this.itemsCount;
    }

    @Override
    public String statusMessage() {
        return this.statusMessage;
    }

    @Override
    public MigrationState state() {
        return this.state;
    }

    @Override
    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    @Override
    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static DatabaseSummaryResult fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseSummaryResult)jsonReader.readObject(reader -> {
            DatabaseSummaryResult deserializedDatabaseSummaryResult = new DatabaseSummaryResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDatabaseSummaryResult.name = reader.getString();
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedDatabaseSummaryResult.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedDatabaseSummaryResult.endedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedDatabaseSummaryResult.state = MigrationState.fromString(reader.getString());
                    continue;
                }
                if ("statusMessage".equals(fieldName)) {
                    deserializedDatabaseSummaryResult.statusMessage = reader.getString();
                    continue;
                }
                if ("itemsCount".equals(fieldName)) {
                    deserializedDatabaseSummaryResult.itemsCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("itemsCompletedCount".equals(fieldName)) {
                    deserializedDatabaseSummaryResult.itemsCompletedCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("errorPrefix".equals(fieldName)) {
                    deserializedDatabaseSummaryResult.errorPrefix = reader.getString();
                    continue;
                }
                if ("resultPrefix".equals(fieldName)) {
                    deserializedDatabaseSummaryResult.resultPrefix = reader.getString();
                    continue;
                }
                if ("sizeMB".equals(fieldName)) {
                    deserializedDatabaseSummaryResult.sizeMB = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseSummaryResult;
        });
    }
}

