/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.AzureActiveDirectoryApp;
import com.azure.resourcemanager.datamigration.models.MiSqlConnectionInfo;
import java.io.IOException;

public final class ConnectToTargetSqlMISyncTaskInput
implements JsonSerializable<ConnectToTargetSqlMISyncTaskInput> {
    private MiSqlConnectionInfo targetConnectionInfo;
    private AzureActiveDirectoryApp azureApp;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectToTargetSqlMISyncTaskInput.class);

    public MiSqlConnectionInfo targetConnectionInfo() {
        return this.targetConnectionInfo;
    }

    public ConnectToTargetSqlMISyncTaskInput withTargetConnectionInfo(MiSqlConnectionInfo targetConnectionInfo) {
        this.targetConnectionInfo = targetConnectionInfo;
        return this;
    }

    public AzureActiveDirectoryApp azureApp() {
        return this.azureApp;
    }

    public ConnectToTargetSqlMISyncTaskInput withAzureApp(AzureActiveDirectoryApp azureApp) {
        this.azureApp = azureApp;
        return this;
    }

    public void validate() {
        if (this.targetConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetConnectionInfo in model ConnectToTargetSqlMISyncTaskInput"));
        }
        this.targetConnectionInfo().validate();
        if (this.azureApp() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property azureApp in model ConnectToTargetSqlMISyncTaskInput"));
        }
        this.azureApp().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("targetConnectionInfo", (JsonSerializable)this.targetConnectionInfo);
        jsonWriter.writeJsonField("azureApp", (JsonSerializable)this.azureApp);
        return jsonWriter.writeEndObject();
    }

    public static ConnectToTargetSqlMISyncTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectToTargetSqlMISyncTaskInput)jsonReader.readObject(reader -> {
            ConnectToTargetSqlMISyncTaskInput deserializedConnectToTargetSqlMISyncTaskInput = new ConnectToTargetSqlMISyncTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetConnectionInfo".equals(fieldName)) {
                    deserializedConnectToTargetSqlMISyncTaskInput.targetConnectionInfo = MiSqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("azureApp".equals(fieldName)) {
                    deserializedConnectToTargetSqlMISyncTaskInput.azureApp = AzureActiveDirectoryApp.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectToTargetSqlMISyncTaskInput;
        });
    }
}

