/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.AzureActiveDirectoryApp;
import com.azure.resourcemanager.datamigration.models.FileShare;
import com.azure.resourcemanager.datamigration.models.MiSqlConnectionInfo;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlMIDatabaseInput;
import com.azure.resourcemanager.datamigration.models.SqlConnectionInfo;
import com.azure.resourcemanager.datamigration.models.SqlServerSqlMISyncTaskInput;
import java.io.IOException;
import java.util.List;

public final class ValidateMigrationInputSqlServerSqlMISyncTaskInput
extends SqlServerSqlMISyncTaskInput {
    private static final ClientLogger LOGGER = new ClientLogger(ValidateMigrationInputSqlServerSqlMISyncTaskInput.class);

    @Override
    public ValidateMigrationInputSqlServerSqlMISyncTaskInput withSelectedDatabases(List<MigrateSqlServerSqlMIDatabaseInput> selectedDatabases) {
        super.withSelectedDatabases(selectedDatabases);
        return this;
    }

    @Override
    public ValidateMigrationInputSqlServerSqlMISyncTaskInput withBackupFileShare(FileShare backupFileShare) {
        super.withBackupFileShare(backupFileShare);
        return this;
    }

    @Override
    public ValidateMigrationInputSqlServerSqlMISyncTaskInput withStorageResourceId(String storageResourceId) {
        super.withStorageResourceId(storageResourceId);
        return this;
    }

    @Override
    public ValidateMigrationInputSqlServerSqlMISyncTaskInput withSourceConnectionInfo(SqlConnectionInfo sourceConnectionInfo) {
        super.withSourceConnectionInfo(sourceConnectionInfo);
        return this;
    }

    @Override
    public ValidateMigrationInputSqlServerSqlMISyncTaskInput withTargetConnectionInfo(MiSqlConnectionInfo targetConnectionInfo) {
        super.withTargetConnectionInfo(targetConnectionInfo);
        return this;
    }

    @Override
    public ValidateMigrationInputSqlServerSqlMISyncTaskInput withAzureApp(AzureActiveDirectoryApp azureApp) {
        super.withAzureApp(azureApp);
        return this;
    }

    @Override
    public void validate() {
        if (this.selectedDatabases() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property selectedDatabases in model ValidateMigrationInputSqlServerSqlMISyncTaskInput"));
        }
        this.selectedDatabases().forEach(e -> e.validate());
        if (this.backupFileShare() != null) {
            this.backupFileShare().validate();
        }
        if (this.storageResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageResourceId in model ValidateMigrationInputSqlServerSqlMISyncTaskInput"));
        }
        if (this.sourceConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceConnectionInfo in model ValidateMigrationInputSqlServerSqlMISyncTaskInput"));
        }
        this.sourceConnectionInfo().validate();
        if (this.targetConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetConnectionInfo in model ValidateMigrationInputSqlServerSqlMISyncTaskInput"));
        }
        this.targetConnectionInfo().validate();
        if (this.azureApp() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property azureApp in model ValidateMigrationInputSqlServerSqlMISyncTaskInput"));
        }
        this.azureApp().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("selectedDatabases", this.selectedDatabases(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("storageResourceId", this.storageResourceId());
        jsonWriter.writeJsonField("sourceConnectionInfo", (JsonSerializable)this.sourceConnectionInfo());
        jsonWriter.writeJsonField("targetConnectionInfo", (JsonSerializable)this.targetConnectionInfo());
        jsonWriter.writeJsonField("azureApp", (JsonSerializable)this.azureApp());
        jsonWriter.writeJsonField("backupFileShare", (JsonSerializable)this.backupFileShare());
        return jsonWriter.writeEndObject();
    }

    public static ValidateMigrationInputSqlServerSqlMISyncTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (ValidateMigrationInputSqlServerSqlMISyncTaskInput)jsonReader.readObject(reader -> {
            ValidateMigrationInputSqlServerSqlMISyncTaskInput deserializedValidateMigrationInputSqlServerSqlMISyncTaskInput = new ValidateMigrationInputSqlServerSqlMISyncTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("selectedDatabases".equals(fieldName)) {
                    List selectedDatabases = reader.readArray(reader1 -> MigrateSqlServerSqlMIDatabaseInput.fromJson(reader1));
                    deserializedValidateMigrationInputSqlServerSqlMISyncTaskInput.withSelectedDatabases(selectedDatabases);
                    continue;
                }
                if ("storageResourceId".equals(fieldName)) {
                    deserializedValidateMigrationInputSqlServerSqlMISyncTaskInput.withStorageResourceId(reader.getString());
                    continue;
                }
                if ("sourceConnectionInfo".equals(fieldName)) {
                    deserializedValidateMigrationInputSqlServerSqlMISyncTaskInput.withSourceConnectionInfo(SqlConnectionInfo.fromJson(reader));
                    continue;
                }
                if ("targetConnectionInfo".equals(fieldName)) {
                    deserializedValidateMigrationInputSqlServerSqlMISyncTaskInput.withTargetConnectionInfo(MiSqlConnectionInfo.fromJson(reader));
                    continue;
                }
                if ("azureApp".equals(fieldName)) {
                    deserializedValidateMigrationInputSqlServerSqlMISyncTaskInput.withAzureApp(AzureActiveDirectoryApp.fromJson(reader));
                    continue;
                }
                if ("backupFileShare".equals(fieldName)) {
                    deserializedValidateMigrationInputSqlServerSqlMISyncTaskInput.withBackupFileShare(FileShare.fromJson(reader));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedValidateMigrationInputSqlServerSqlMISyncTaskInput;
        });
    }
}

