/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.AuthenticationType;
import com.azure.resourcemanager.datamigration.models.ConnectionInfo;
import com.azure.resourcemanager.datamigration.models.SqlSourcePlatform;
import java.io.IOException;

public final class SqlConnectionInfo
extends ConnectionInfo {
    private String type = "SqlConnectionInfo";
    private String dataSource;
    private String serverName;
    private Integer port;
    private String serverVersion;
    private String serverBrandVersion;
    private String resourceId;
    private AuthenticationType authentication;
    private Boolean encryptConnection;
    private String additionalSettings;
    private Boolean trustServerCertificate;
    private SqlSourcePlatform platform;
    private static final ClientLogger LOGGER = new ClientLogger(SqlConnectionInfo.class);

    @Override
    public String type() {
        return this.type;
    }

    public String dataSource() {
        return this.dataSource;
    }

    public SqlConnectionInfo withDataSource(String dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public String serverName() {
        return this.serverName;
    }

    public SqlConnectionInfo withServerName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public Integer port() {
        return this.port;
    }

    public SqlConnectionInfo withPort(Integer port) {
        this.port = port;
        return this;
    }

    public String serverVersion() {
        return this.serverVersion;
    }

    public SqlConnectionInfo withServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
        return this;
    }

    public String serverBrandVersion() {
        return this.serverBrandVersion;
    }

    public SqlConnectionInfo withServerBrandVersion(String serverBrandVersion) {
        this.serverBrandVersion = serverBrandVersion;
        return this;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public SqlConnectionInfo withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public AuthenticationType authentication() {
        return this.authentication;
    }

    public SqlConnectionInfo withAuthentication(AuthenticationType authentication) {
        this.authentication = authentication;
        return this;
    }

    public Boolean encryptConnection() {
        return this.encryptConnection;
    }

    public SqlConnectionInfo withEncryptConnection(Boolean encryptConnection) {
        this.encryptConnection = encryptConnection;
        return this;
    }

    public String additionalSettings() {
        return this.additionalSettings;
    }

    public SqlConnectionInfo withAdditionalSettings(String additionalSettings) {
        this.additionalSettings = additionalSettings;
        return this;
    }

    public Boolean trustServerCertificate() {
        return this.trustServerCertificate;
    }

    public SqlConnectionInfo withTrustServerCertificate(Boolean trustServerCertificate) {
        this.trustServerCertificate = trustServerCertificate;
        return this;
    }

    public SqlSourcePlatform platform() {
        return this.platform;
    }

    public SqlConnectionInfo withPlatform(SqlSourcePlatform platform) {
        this.platform = platform;
        return this;
    }

    @Override
    public SqlConnectionInfo withUsername(String username) {
        super.withUsername(username);
        return this;
    }

    @Override
    public SqlConnectionInfo withPassword(String password) {
        super.withPassword(password);
        return this;
    }

    @Override
    public void validate() {
        if (this.dataSource() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dataSource in model SqlConnectionInfo"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("userName", this.username());
        jsonWriter.writeStringField("password", this.password());
        jsonWriter.writeStringField("dataSource", this.dataSource);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("serverName", this.serverName);
        jsonWriter.writeNumberField("port", (Number)this.port);
        jsonWriter.writeStringField("serverVersion", this.serverVersion);
        jsonWriter.writeStringField("serverBrandVersion", this.serverBrandVersion);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("authentication", this.authentication == null ? null : this.authentication.toString());
        jsonWriter.writeBooleanField("encryptConnection", this.encryptConnection);
        jsonWriter.writeStringField("additionalSettings", this.additionalSettings);
        jsonWriter.writeBooleanField("trustServerCertificate", this.trustServerCertificate);
        jsonWriter.writeStringField("platform", this.platform == null ? null : this.platform.toString());
        return jsonWriter.writeEndObject();
    }

    public static SqlConnectionInfo fromJson(JsonReader jsonReader) throws IOException {
        return (SqlConnectionInfo)jsonReader.readObject(reader -> {
            SqlConnectionInfo deserializedSqlConnectionInfo = new SqlConnectionInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("userName".equals(fieldName)) {
                    deserializedSqlConnectionInfo.withUsername(reader.getString());
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedSqlConnectionInfo.withPassword(reader.getString());
                    continue;
                }
                if ("dataSource".equals(fieldName)) {
                    deserializedSqlConnectionInfo.dataSource = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSqlConnectionInfo.type = reader.getString();
                    continue;
                }
                if ("serverName".equals(fieldName)) {
                    deserializedSqlConnectionInfo.serverName = reader.getString();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedSqlConnectionInfo.port = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("serverVersion".equals(fieldName)) {
                    deserializedSqlConnectionInfo.serverVersion = reader.getString();
                    continue;
                }
                if ("serverBrandVersion".equals(fieldName)) {
                    deserializedSqlConnectionInfo.serverBrandVersion = reader.getString();
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedSqlConnectionInfo.resourceId = reader.getString();
                    continue;
                }
                if ("authentication".equals(fieldName)) {
                    deserializedSqlConnectionInfo.authentication = AuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("encryptConnection".equals(fieldName)) {
                    deserializedSqlConnectionInfo.encryptConnection = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("additionalSettings".equals(fieldName)) {
                    deserializedSqlConnectionInfo.additionalSettings = reader.getString();
                    continue;
                }
                if ("trustServerCertificate".equals(fieldName)) {
                    deserializedSqlConnectionInfo.trustServerCertificate = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("platform".equals(fieldName)) {
                    deserializedSqlConnectionInfo.platform = SqlSourcePlatform.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlConnectionInfo;
        });
    }
}

