/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.SchemaComparisonValidationResultType;
import com.azure.resourcemanager.datamigration.models.ValidationError;
import java.io.IOException;
import java.util.Map;

public final class SchemaComparisonValidationResult
implements JsonSerializable<SchemaComparisonValidationResult> {
    private SchemaComparisonValidationResultType schemaDifferences;
    private ValidationError validationErrors;
    private Map<String, Long> sourceDatabaseObjectCount;
    private Map<String, Long> targetDatabaseObjectCount;

    public SchemaComparisonValidationResultType schemaDifferences() {
        return this.schemaDifferences;
    }

    public SchemaComparisonValidationResult withSchemaDifferences(SchemaComparisonValidationResultType schemaDifferences) {
        this.schemaDifferences = schemaDifferences;
        return this;
    }

    public ValidationError validationErrors() {
        return this.validationErrors;
    }

    public SchemaComparisonValidationResult withValidationErrors(ValidationError validationErrors) {
        this.validationErrors = validationErrors;
        return this;
    }

    public Map<String, Long> sourceDatabaseObjectCount() {
        return this.sourceDatabaseObjectCount;
    }

    public SchemaComparisonValidationResult withSourceDatabaseObjectCount(Map<String, Long> sourceDatabaseObjectCount) {
        this.sourceDatabaseObjectCount = sourceDatabaseObjectCount;
        return this;
    }

    public Map<String, Long> targetDatabaseObjectCount() {
        return this.targetDatabaseObjectCount;
    }

    public SchemaComparisonValidationResult withTargetDatabaseObjectCount(Map<String, Long> targetDatabaseObjectCount) {
        this.targetDatabaseObjectCount = targetDatabaseObjectCount;
        return this;
    }

    public void validate() {
        if (this.schemaDifferences() != null) {
            this.schemaDifferences().validate();
        }
        if (this.validationErrors() != null) {
            this.validationErrors().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("schemaDifferences", (JsonSerializable)this.schemaDifferences);
        jsonWriter.writeJsonField("validationErrors", (JsonSerializable)this.validationErrors);
        jsonWriter.writeMapField("sourceDatabaseObjectCount", this.sourceDatabaseObjectCount, (writer, element) -> writer.writeLong(element.longValue()));
        jsonWriter.writeMapField("targetDatabaseObjectCount", this.targetDatabaseObjectCount, (writer, element) -> writer.writeLong(element.longValue()));
        return jsonWriter.writeEndObject();
    }

    public static SchemaComparisonValidationResult fromJson(JsonReader jsonReader) throws IOException {
        return (SchemaComparisonValidationResult)jsonReader.readObject(reader -> {
            SchemaComparisonValidationResult deserializedSchemaComparisonValidationResult = new SchemaComparisonValidationResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("schemaDifferences".equals(fieldName)) {
                    deserializedSchemaComparisonValidationResult.schemaDifferences = SchemaComparisonValidationResultType.fromJson(reader);
                    continue;
                }
                if ("validationErrors".equals(fieldName)) {
                    deserializedSchemaComparisonValidationResult.validationErrors = ValidationError.fromJson(reader);
                    continue;
                }
                if ("sourceDatabaseObjectCount".equals(fieldName)) {
                    Map sourceDatabaseObjectCount;
                    deserializedSchemaComparisonValidationResult.sourceDatabaseObjectCount = sourceDatabaseObjectCount = reader.readMap(reader1 -> reader1.getLong());
                    continue;
                }
                if ("targetDatabaseObjectCount".equals(fieldName)) {
                    Map targetDatabaseObjectCount;
                    deserializedSchemaComparisonValidationResult.targetDatabaseObjectCount = targetDatabaseObjectCount = reader.readMap(reader1 -> reader1.getLong());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSchemaComparisonValidationResult;
        });
    }
}

