/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.AuthenticationType;
import com.azure.resourcemanager.datamigration.models.ConnectionInfo;
import java.io.IOException;

public final class OracleConnectionInfo
extends ConnectionInfo {
    private String type = "OracleConnectionInfo";
    private String dataSource;
    private String serverName;
    private String serverVersion;
    private Integer port;
    private AuthenticationType authentication;
    private static final ClientLogger LOGGER = new ClientLogger(OracleConnectionInfo.class);

    @Override
    public String type() {
        return this.type;
    }

    public String dataSource() {
        return this.dataSource;
    }

    public OracleConnectionInfo withDataSource(String dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public String serverName() {
        return this.serverName;
    }

    public OracleConnectionInfo withServerName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public String serverVersion() {
        return this.serverVersion;
    }

    public OracleConnectionInfo withServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
        return this;
    }

    public Integer port() {
        return this.port;
    }

    public OracleConnectionInfo withPort(Integer port) {
        this.port = port;
        return this;
    }

    public AuthenticationType authentication() {
        return this.authentication;
    }

    public OracleConnectionInfo withAuthentication(AuthenticationType authentication) {
        this.authentication = authentication;
        return this;
    }

    @Override
    public OracleConnectionInfo withUsername(String username) {
        super.withUsername(username);
        return this;
    }

    @Override
    public OracleConnectionInfo withPassword(String password) {
        super.withPassword(password);
        return this;
    }

    @Override
    public void validate() {
        if (this.dataSource() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dataSource in model OracleConnectionInfo"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("userName", this.username());
        jsonWriter.writeStringField("password", this.password());
        jsonWriter.writeStringField("dataSource", this.dataSource);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("serverName", this.serverName);
        jsonWriter.writeStringField("serverVersion", this.serverVersion);
        jsonWriter.writeNumberField("port", (Number)this.port);
        jsonWriter.writeStringField("authentication", this.authentication == null ? null : this.authentication.toString());
        return jsonWriter.writeEndObject();
    }

    public static OracleConnectionInfo fromJson(JsonReader jsonReader) throws IOException {
        return (OracleConnectionInfo)jsonReader.readObject(reader -> {
            OracleConnectionInfo deserializedOracleConnectionInfo = new OracleConnectionInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("userName".equals(fieldName)) {
                    deserializedOracleConnectionInfo.withUsername(reader.getString());
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedOracleConnectionInfo.withPassword(reader.getString());
                    continue;
                }
                if ("dataSource".equals(fieldName)) {
                    deserializedOracleConnectionInfo.dataSource = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedOracleConnectionInfo.type = reader.getString();
                    continue;
                }
                if ("serverName".equals(fieldName)) {
                    deserializedOracleConnectionInfo.serverName = reader.getString();
                    continue;
                }
                if ("serverVersion".equals(fieldName)) {
                    deserializedOracleConnectionInfo.serverVersion = reader.getString();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedOracleConnectionInfo.port = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("authentication".equals(fieldName)) {
                    deserializedOracleConnectionInfo.authentication = AuthenticationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOracleConnectionInfo;
        });
    }
}

